/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.readers.operation.parameter;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.mangofactory.swagger.ScalaUtils;
import com.mangofactory.swagger.readers.Command;
import com.mangofactory.swagger.scanners.RequestMappingContext;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.model.AllowableListValues;
import com.wordnik.swagger.model.AllowableRangeValues;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;

public class ParameterAllowableReader
implements Command<RequestMappingContext> {
    private static final Logger log = LoggerFactory.getLogger(ParameterAllowableReader.class);

    @Override
    public void execute(RequestMappingContext context) {
        MethodParameter methodParameter = (MethodParameter)context.get("methodParameter");
        AllowableListValues allowableValues = null;
        String allowableValueString = this.findAnnotatedAllowableValues(methodParameter);
        if (allowableValueString != null && !"".equals(allowableValueString)) {
            if ((allowableValueString = allowableValueString.trim().replaceAll(" ", "")).startsWith("range[")) {
                allowableValueString = allowableValueString.replaceAll("range\\[", "").replaceAll("]", "");
                Iterable split = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)allowableValueString);
                ArrayList ranges = Lists.newArrayList((Iterable)split);
                allowableValues = new AllowableRangeValues((String)ranges.get(0), (String)ranges.get(1));
            } else if (allowableValueString.contains(",")) {
                Iterable split = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)allowableValueString);
                allowableValues = new AllowableListValues(ScalaUtils.toScalaList(Lists.newArrayList((Iterable)split)), "LIST");
            } else if (!StringUtils.isBlank((String)allowableValueString)) {
                List<String> singleVal = Arrays.asList(allowableValueString.trim());
                allowableValues = new AllowableListValues(ScalaUtils.toScalaList(singleVal), "LIST");
            }
        } else {
            ArrayList<String> enumNames;
            Object[] enumConstants;
            if (methodParameter.getParameterType().isEnum()) {
                enumConstants = methodParameter.getParameterType().getEnumConstants();
                enumNames = new ArrayList<String>();
                for (Object o : enumConstants) {
                    enumNames.add(o.toString());
                }
                allowableValues = new AllowableListValues(ScalaUtils.toScalaList(Lists.newArrayList(enumNames)), "LIST");
            }
            if (methodParameter.getParameterType().isArray() && methodParameter.getParameterType().getComponentType().isEnum()) {
                enumConstants = methodParameter.getParameterType().getComponentType().getEnumConstants();
                enumNames = new ArrayList();
                for (Object o : enumConstants) {
                    enumNames.add(o.toString());
                }
                allowableValues = new AllowableListValues(ScalaUtils.toScalaList(Lists.newArrayList(enumNames)), "LIST");
            }
        }
        context.put("allowableValues", allowableValues);
    }

    private String findAnnotatedAllowableValues(MethodParameter methodParameter) {
        Annotation[] methodAnnotations = methodParameter.getParameterAnnotations();
        if (null != methodAnnotations) {
            for (Annotation annotation : methodAnnotations) {
                if (!(annotation instanceof ApiParam)) continue;
                return ((ApiParam)annotation).allowableValues();
            }
        }
        return null;
    }
}

