/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.scanners;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.mangofactory.swagger.ScalaUtils;
import com.mangofactory.swagger.core.ResourceGroupingStrategy;
import com.mangofactory.swagger.paths.SwaggerPathProvider;
import com.mangofactory.swagger.scanners.RegexRequestMappingPatternMatcher;
import com.mangofactory.swagger.scanners.RequestMappingContext;
import com.mangofactory.swagger.scanners.RequestMappingPatternMatcher;
import com.mangofactory.swagger.scanners.ResourceGroup;
import com.wordnik.swagger.model.ApiListingReference;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class ApiListingReferenceScanner {
    private static final String REQUEST_MAPPINGS_EMPTY = "No RequestMappingHandlerMapping's found have you added <mvc:annotation-driven/>";
    private static final Logger log = LoggerFactory.getLogger(ApiListingReferenceScanner.class);
    private List<RequestMappingHandlerMapping> requestMappingHandlerMapping;
    private List<ApiListingReference> apiListingReferences = Lists.newArrayList();
    private ArrayListMultimap<ResourceGroup, RequestMappingContext> resourceGroupRequestMappings = ArrayListMultimap.create();
    private String swaggerGroup;
    private List<Class<? extends Annotation>> excludeAnnotations;
    private ResourceGroupingStrategy resourceGroupingStrategy;
    private SwaggerPathProvider swaggerPathProvider;
    private List<String> includePatterns = Lists.newArrayList((Object[])new String[]{".*?"});
    private RequestMappingPatternMatcher requestMappingPatternMatcher = new RegexRequestMappingPatternMatcher();

    public List<ApiListingReference> scan() {
        Assert.notNull(this.requestMappingHandlerMapping, (String)REQUEST_MAPPINGS_EMPTY);
        Assert.notEmpty(this.requestMappingHandlerMapping, (String)REQUEST_MAPPINGS_EMPTY);
        Assert.notNull((Object)this.resourceGroupingStrategy, (String)"resourceGroupingStrategy is required");
        Assert.notNull((Object)this.swaggerGroup, (String)"swaggerGroup is required");
        if (StringUtils.isBlank((String)this.swaggerGroup)) {
            throw new IllegalArgumentException("swaggerGroup must not be empty");
        }
        Assert.notNull((Object)this.swaggerPathProvider, (String)"swaggerPathProvider is required");
        log.info("Scanning for api listing references");
        this.scanSpringRequestMappings();
        return this.apiListingReferences;
    }

    public void scanSpringRequestMappings() {
        HashMap<ResourceGroup, String> resourceGroupDescriptions = new HashMap<ResourceGroup, String>();
        for (RequestMappingHandlerMapping requestMappingHandlerMapping : this.requestMappingHandlerMapping) {
            for (Map.Entry handlerMethodEntry : requestMappingHandlerMapping.getHandlerMethods().entrySet()) {
                HandlerMethod handlerMethod;
                RequestMappingInfo requestMappingInfo = (RequestMappingInfo)handlerMethodEntry.getKey();
                if (!this.shouldIncludeRequestMapping(requestMappingInfo, handlerMethod = (HandlerMethod)handlerMethodEntry.getValue())) continue;
                Set<ResourceGroup> resourceGroups = this.resourceGroupingStrategy.getResourceGroups(requestMappingInfo, handlerMethod);
                String handlerMethodName = handlerMethod.getMethod().getName();
                String resourceDescription = this.resourceGroupingStrategy.getResourceDescription(requestMappingInfo, handlerMethod);
                RequestMappingContext requestMappingContext = new RequestMappingContext(requestMappingInfo, handlerMethod);
                log.info("Request mapping: {} belongs to groups: [{}] ", (Object)handlerMethodName, resourceGroups);
                for (ResourceGroup group : resourceGroups) {
                    resourceGroupDescriptions.put(group, resourceDescription);
                    log.info("Adding resource to group:{} with description:{} for handler method:{}", new Object[]{group, resourceDescription, handlerMethodName});
                    this.resourceGroupRequestMappings.put((Object)group, (Object)requestMappingContext);
                }
            }
        }
        for (ResourceGroup resourceGroup : resourceGroupDescriptions.keySet()) {
            String resourceGroupName = resourceGroup.getGroupName();
            String listingDescription = (String)resourceGroupDescriptions.get(resourceGroup);
            Integer position = resourceGroup.getPosition();
            String path = this.swaggerPathProvider.getResourceListingPath(this.swaggerGroup, resourceGroupName);
            log.info("Created resource listing Path: {} Description: {} Position: {}", new Object[]{path, resourceGroupName, position});
            this.apiListingReferences.add(new ApiListingReference(path, ScalaUtils.toOption(listingDescription), position.intValue()));
        }
    }

    private boolean requestMappingMatchesAnIncludePattern(RequestMappingInfo requestMappingInfo, HandlerMethod handlerMethod) {
        PatternsRequestCondition patternsCondition = requestMappingInfo.getPatternsCondition();
        boolean isMatch = this.requestMappingPatternMatcher.patternConditionsMatchOneOfIncluded(patternsCondition, this.includePatterns);
        if (isMatch) {
            return true;
        }
        log.info(String.format("RequestMappingInfo did not match any include patterns: | %s", requestMappingInfo));
        return false;
    }

    private boolean shouldIncludeRequestMapping(RequestMappingInfo requestMappingInfo, HandlerMethod handlerMethod) {
        return this.requestMappingMatchesAnIncludePattern(requestMappingInfo, handlerMethod) && !this.hasIgnoredAnnotatedRequestMapping(handlerMethod);
    }

    public boolean hasIgnoredAnnotatedRequestMapping(HandlerMethod handlerMethod) {
        if (null != this.excludeAnnotations) {
            for (Class<? extends Annotation> annotation : this.excludeAnnotations) {
                if (null == AnnotationUtils.findAnnotation((Method)handlerMethod.getMethod(), annotation)) continue;
                log.info(String.format("Excluding method as it contains the excluded annotation: %s", annotation));
                return true;
            }
        }
        return false;
    }

    public Map<ResourceGroup, List<RequestMappingContext>> getResourceGroupRequestMappings() {
        return Multimaps.asMap(this.resourceGroupRequestMappings);
    }

    public List<RequestMappingHandlerMapping> getRequestMappingHandlerMapping() {
        return this.requestMappingHandlerMapping;
    }

    public void setRequestMappingHandlerMapping(List<RequestMappingHandlerMapping> requestMappingHandlerMapping) {
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
    }

    public List<ApiListingReference> getApiListingReferences() {
        return this.apiListingReferences;
    }

    public void setApiListingReferences(List<ApiListingReference> apiListingReferences) {
        this.apiListingReferences = apiListingReferences;
    }

    public void setResourceGroupRequestMappings(ArrayListMultimap<ResourceGroup, RequestMappingContext> resourceGroupRequestMappings) {
        this.resourceGroupRequestMappings = resourceGroupRequestMappings;
    }

    public String getSwaggerGroup() {
        return this.swaggerGroup;
    }

    public void setSwaggerGroup(String swaggerGroup) {
        this.swaggerGroup = swaggerGroup;
    }

    public List<Class<? extends Annotation>> getExcludeAnnotations() {
        return this.excludeAnnotations;
    }

    public void setExcludeAnnotations(List<Class<? extends Annotation>> excludeAnnotations) {
        this.excludeAnnotations = excludeAnnotations;
    }

    public ResourceGroupingStrategy getResourceGroupingStrategy() {
        return this.resourceGroupingStrategy;
    }

    public void setResourceGroupingStrategy(ResourceGroupingStrategy resourceGroupingStrategy) {
        this.resourceGroupingStrategy = resourceGroupingStrategy;
    }

    public SwaggerPathProvider getSwaggerPathProvider() {
        return this.swaggerPathProvider;
    }

    public void setSwaggerPathProvider(SwaggerPathProvider swaggerPathProvider) {
        this.swaggerPathProvider = swaggerPathProvider;
    }

    public List<String> getIncludePatterns() {
        return this.includePatterns;
    }

    public void setIncludePatterns(List<String> includePatterns) {
        this.includePatterns = includePatterns;
    }

    public RequestMappingPatternMatcher getRequestMappingPatternMatcher() {
        return this.requestMappingPatternMatcher;
    }

    public void setRequestMappingPatternMatcher(RequestMappingPatternMatcher requestMappingPatternMatcher) {
        this.requestMappingPatternMatcher = requestMappingPatternMatcher;
    }
}

