/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.readers.operation;

import com.google.common.collect.Lists;
import com.mangofactory.swagger.authorization.AuthorizationContext;
import com.mangofactory.swagger.readers.operation.RequestMappingReader;
import com.mangofactory.swagger.scanners.RequestMappingContext;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.Authorization;
import com.wordnik.swagger.model.AuthorizationScope;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.method.HandlerMethod;

public class OperationAuthReader
implements RequestMappingReader {
    @Override
    public void execute(RequestMappingContext context) {
        Authorization[] authorizationAnnotations;
        ApiOperation apiOperationAnnotation;
        AuthorizationContext authorizationContext = (AuthorizationContext)context.get("authorizationContext");
        HandlerMethod handlerMethod = context.getHandlerMethod();
        String requestMappingPattern = (String)context.get("requestMappingPattern");
        List<Object> authorizations = Lists.newArrayList();
        if (null != authorizationContext) {
            authorizations = authorizationContext.getAuthorizationsForPath(requestMappingPattern);
        }
        if (null != (apiOperationAnnotation = (ApiOperation)handlerMethod.getMethodAnnotation(ApiOperation.class)) && null != apiOperationAnnotation.authorizations() && (authorizationAnnotations = apiOperationAnnotation.authorizations()) != null && authorizationAnnotations.length > 0 && !StringUtils.isBlank((String)authorizationAnnotations[0].value())) {
            authorizations = Lists.newArrayList();
            for (Authorization authorization : authorizationAnnotations) {
                String value = authorization.value();
                com.wordnik.swagger.annotations.AuthorizationScope[] scopes = authorization.scopes();
                ArrayList authorizationScopeList = Lists.newArrayList();
                for (com.wordnik.swagger.annotations.AuthorizationScope authorizationScope : scopes) {
                    String description = authorizationScope.description();
                    String scope = authorizationScope.scope();
                    authorizationScopeList.add(new AuthorizationScope(scope, description));
                }
                AuthorizationScope[] authorizationScopes = authorizationScopeList.toArray(new AuthorizationScope[authorizationScopeList.size()]);
                com.wordnik.swagger.model.Authorization authorizationModel = new com.wordnik.swagger.model.Authorization(value, authorizationScopes);
                authorizations.add(authorizationModel);
            }
        }
        context.put("authorizations", authorizations);
    }
}

