package com.mangofactory.swagger.plugin;

import com.mangofactory.swagger.configuration.SpringSwaggerConfig;
import org.springframework.context.annotation.Import;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Indicates that Swagger support should be enabled.
 * <p/>
 * This should be applied to a Spring java config and should have an accompanying '@Configuration' annotation.
 * <p/>
 * Loads all required beans defined in @see SpringSwaggerConfig
 *
 * @see com.mangofactory.swagger.plugin.SwaggerSpringMvcPlugin
 */
@Retention(value = java.lang.annotation.RetentionPolicy.RUNTIME)
@Target(value = {java.lang.annotation.ElementType.TYPE})
@Documented
@Import(SpringSwaggerConfig.class)
public @interface EnableSwagger {
}
