/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.readers.operation.parameter;

import com.mangofactory.swagger.models.Types;
import com.mangofactory.swagger.readers.operation.parameter.ParameterBuilder;
import com.wordnik.swagger.model.Parameter;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class ModelAttributeParameterExpander {
    ModelAttributeParameterExpander() {
    }

    public void expand(String parentName, Class<?> paramType, List<Parameter> parameters) {
        Set<String> beanPropNames = this.getBeanPropertyNames(paramType);
        List<Field> fields = this.getAllFields(paramType);
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers()) || field.isSynthetic() || !beanPropNames.contains(field.getName())) continue;
            if (!this.typeBelongsToJavaPackage(field) && !field.getType().isEnum()) {
                this.expand(field.getName(), field.getType(), parameters);
                continue;
            }
            String dataTypeName = Types.typeNameFor(field.getType());
            if (dataTypeName == null) {
                dataTypeName = field.getType().getSimpleName();
            }
            parameters.add(new ParameterBuilder().forField(field).withDataTypeName(dataTypeName).withParentName(parentName).build());
        }
    }

    private boolean typeBelongsToJavaPackage(Field field) {
        return field.getType().getPackage() == null || field.getType().getPackage().getName().startsWith("java");
    }

    private List<Field> getAllFields(Class<?> type) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Class<?> i = type; i != null && i != Object.class; i = i.getSuperclass()) {
            result.addAll(Arrays.asList(i.getDeclaredFields()));
        }
        return result;
    }

    private Set<String> getBeanPropertyNames(Class<?> clazz) {
        try {
            HashSet<String> beanProps = new HashSet<String>();
            PropertyDescriptor[] propDescriptors = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
            for (int i = 0; i < propDescriptors.length; ++i) {
                if (propDescriptors[i].getReadMethod() == null || propDescriptors[i].getWriteMethod() == null) continue;
                beanProps.add(propDescriptors[i].getName());
            }
            return beanProps;
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Failed to get bean properties on " + clazz, e);
        }
    }
}

