/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mangofactory.swagger.ScalaUtils;
import com.mangofactory.swagger.configuration.SwaggerGlobalSettings;
import com.mangofactory.swagger.core.ModelUtils;
import com.mangofactory.swagger.models.Annotations;
import com.mangofactory.swagger.models.ResolvedTypes;
import com.mangofactory.swagger.readers.operation.SwaggerResponseMessageReader;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import com.wordnik.swagger.model.ResponseMessage;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import scala.Option;

public class DefaultResponseMessageReader
extends SwaggerResponseMessageReader {
    @Override
    protected Collection<ResponseMessage> read(SwaggerGlobalSettings swaggerGlobalSettings, RequestMethod currentHttpMethod, HandlerMethod handlerMethod) {
        List<ResponseMessage> responseMessages = this.globalResponseMessages(swaggerGlobalSettings, currentHttpMethod);
        HashMap byStatusCode = Maps.newHashMap((Map)Maps.uniqueIndex(responseMessages, this.byStatusCode()));
        this.applyAnnotatedOverrides(swaggerGlobalSettings, handlerMethod, byStatusCode);
        this.applyReturnTypeOverride(swaggerGlobalSettings, handlerMethod, byStatusCode);
        return byStatusCode.values();
    }

    private void applyReturnTypeOverride(SwaggerGlobalSettings swaggerGlobalSettings, HandlerMethod handlerMethod, Map<Integer, ResponseMessage> byStatusCode) {
        ResolvedType returnType = ModelUtils.handlerReturnType(swaggerGlobalSettings.getTypeResolver(), handlerMethod);
        returnType = swaggerGlobalSettings.getAlternateTypeProvider().alternateFor(returnType);
        if (!Void.class.equals((Object)returnType.getErasedType()) && !Void.TYPE.equals(returnType.getErasedType())) {
            ResponseMessage responseMessage = byStatusCode.get(200);
            String message = null;
            if (responseMessage != null) {
                message = this.coalese(responseMessage.message(), HttpStatus.OK.getReasonPhrase());
            }
            String simpleName = ResolvedTypes.typeName((ResolvedType)returnType);
            ResponseMessage responseWithModel = new ResponseMessage(200, message, ScalaUtils.toOption(simpleName));
            byStatusCode.put(200, responseWithModel);
        }
    }

    private void applyAnnotatedOverrides(SwaggerGlobalSettings swaggerGlobalSettings, HandlerMethod handlerMethod, Map<Integer, ResponseMessage> byStatusCode) {
        Optional apiResponsesOptional = Annotations.findApiResponsesAnnotations((AnnotatedElement)handlerMethod.getMethod());
        if (apiResponsesOptional.isPresent()) {
            ApiResponse[] apiResponseAnnotations;
            for (ApiResponse apiResponse : apiResponseAnnotations = ((ApiResponses)apiResponsesOptional.get()).value()) {
                String overrideTypeName = this.overrideTypeName(swaggerGlobalSettings, apiResponse);
                ResponseMessage responseMessage = byStatusCode.get(apiResponse.code());
                if (null == responseMessage) {
                    byStatusCode.put(apiResponse.code(), new ResponseMessage(apiResponse.code(), apiResponse.message(), ScalaUtils.toOption(overrideTypeName)));
                    continue;
                }
                Option responseModel = responseMessage.responseModel();
                if (!Strings.isNullOrEmpty((String)overrideTypeName)) {
                    responseModel = ScalaUtils.toOption(overrideTypeName);
                }
                byStatusCode.put(apiResponse.code(), new ResponseMessage(apiResponse.code(), this.coalese(apiResponse.message(), responseMessage.message()), responseModel));
            }
        }
    }

    private String overrideTypeName(SwaggerGlobalSettings swaggerGlobalSettings, ApiResponse apiResponse) {
        if (apiResponse.response() != null) {
            return ResolvedTypes.typeName((ResolvedType)swaggerGlobalSettings.getTypeResolver().resolve((Type)apiResponse.response(), new Type[0]));
        }
        return "";
    }

    private String coalese(String overrideMessage, String defaultMessage) {
        if (Strings.isNullOrEmpty((String)overrideMessage)) {
            return defaultMessage;
        }
        return overrideMessage;
    }

    private Function<? super ResponseMessage, Integer> byStatusCode() {
        return new Function<ResponseMessage, Integer>(){

            public Integer apply(ResponseMessage input) {
                return input.code();
            }
        };
    }

    private List<ResponseMessage> globalResponseMessages(SwaggerGlobalSettings swaggerGlobalSettings, RequestMethod currentHttpMethod) {
        List<Object> responseMessages = Lists.newArrayList();
        Map<RequestMethod, List<ResponseMessage>> globalResponseMessages = swaggerGlobalSettings.getGlobalResponseMessages();
        if (null != globalResponseMessages) {
            responseMessages = globalResponseMessages.get(currentHttpMethod);
        }
        return responseMessages;
    }
}

