/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.authorization;

import com.mangofactory.swagger.ScalaUtils;
import com.mangofactory.swagger.scanners.RegexRequestMappingPatternMatcher;
import com.mangofactory.swagger.scanners.RequestMappingPatternMatcher;
import com.wordnik.swagger.model.Authorization;
import java.util.Arrays;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import scala.collection.immutable.List;

public class AuthorizationContext {
    private final java.util.List<Authorization> authorizations;
    private final RequestMappingPatternMatcher requestMappingPatternMatcher;
    private final java.util.List<String> includePatterns;
    private final RequestMethod[] requestMethods;

    private AuthorizationContext(AuthorizationContextBuilder builder) {
        this.authorizations = builder.authorizations;
        this.includePatterns = builder.includePatterns;
        this.requestMappingPatternMatcher = builder.requestMappingPatternMatcher;
        this.requestMethods = builder.requestMethods;
    }

    public java.util.List<Authorization> getAuthorizationsForPath(String path) {
        if (this.requestMappingPatternMatcher.pathMatchesOneOfIncluded(path, this.includePatterns)) {
            return this.authorizations;
        }
        return null;
    }

    public java.util.List<Authorization> getAuthorizations() {
        return this.authorizations;
    }

    public List<Authorization> getScalaAuthorizations() {
        if (!CollectionUtils.isEmpty(this.authorizations)) {
            return ScalaUtils.toScalaList(this.authorizations);
        }
        return ScalaUtils.emptyScalaList();
    }

    public static class AuthorizationContextBuilder {
        private java.util.List<Authorization> authorizations;
        private RequestMappingPatternMatcher requestMappingPatternMatcher = new RegexRequestMappingPatternMatcher();
        private java.util.List<String> includePatterns = Arrays.asList(".*?");
        private RequestMethod[] requestMethods = RequestMethod.values();

        public AuthorizationContextBuilder(java.util.List<Authorization> authorizations) {
            this.authorizations = authorizations;
        }

        public AuthorizationContextBuilder withRequestMappingPatternMatcher(RequestMappingPatternMatcher matcher) {
            this.requestMappingPatternMatcher = matcher;
            return this;
        }

        public AuthorizationContextBuilder withIncludePatterns(java.util.List<String> includePatterns) {
            this.includePatterns = includePatterns;
            return this;
        }

        public AuthorizationContextBuilder withRequestMethods(RequestMethod[] requestMethods) {
            this.requestMethods = requestMethods;
            return this;
        }

        public AuthorizationContext build() {
            return new AuthorizationContext(this);
        }
    }
}

