/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.plugin;

import com.fasterxml.classmate.TypeResolver;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.mangofactory.swagger.authorization.AuthorizationContext;
import com.mangofactory.swagger.configuration.SpringSwaggerConfig;
import com.mangofactory.swagger.configuration.SwaggerGlobalSettings;
import com.mangofactory.swagger.core.ResourceGroupingStrategy;
import com.mangofactory.swagger.core.SwaggerApiResourceListing;
import com.mangofactory.swagger.models.ModelProvider;
import com.mangofactory.swagger.models.alternates.AlternateTypeProvider;
import com.mangofactory.swagger.models.alternates.AlternateTypeRule;
import com.mangofactory.swagger.models.alternates.Alternates;
import com.mangofactory.swagger.models.alternates.WildcardType;
import com.mangofactory.swagger.ordering.ApiDescriptionLexicographicalOrdering;
import com.mangofactory.swagger.ordering.ResourceListingLexicographicalOrdering;
import com.mangofactory.swagger.paths.SwaggerPathProvider;
import com.mangofactory.swagger.readers.operation.RequestMappingReader;
import com.mangofactory.swagger.scanners.ApiListingReferenceScanner;
import com.wordnik.swagger.model.ApiDescription;
import com.wordnik.swagger.model.ApiInfo;
import com.wordnik.swagger.model.ApiListingReference;
import com.wordnik.swagger.model.AuthorizationType;
import com.wordnik.swagger.model.ResponseMessage;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMethod;

public class SwaggerSpringMvcPlugin {
    private ModelProvider modelProvider;
    private String swaggerGroup;
    private List<String> includePatterns;
    private SwaggerPathProvider swaggerPathProvider;
    private List<AuthorizationType> authorizationTypes;
    private ApiInfo apiInfo;
    private AuthorizationContext authorizationContext;
    private List<Class<? extends Annotation>> excludeAnnotations = new ArrayList<Class<? extends Annotation>>();
    private ResourceGroupingStrategy resourceGroupingStrategy;
    private String apiVersion = "1.0";
    private SwaggerGlobalSettings swaggerGlobalSettings = new SwaggerGlobalSettings();
    private Map<RequestMethod, List<ResponseMessage>> globalResponseMessages = Maps.newHashMap();
    private Set<Class> ignorableParameterTypes = new HashSet<Class>();
    private AlternateTypeProvider alternateTypeProvider;
    private List<AlternateTypeRule> alternateTypeRules = new ArrayList<AlternateTypeRule>();
    private SpringSwaggerConfig springSwaggerConfig;
    private SwaggerApiResourceListing swaggerApiResourceListing;
    private Ordering<ApiListingReference> apiListingReferenceOrdering = new ResourceListingLexicographicalOrdering();
    private Ordering<ApiDescription> apiDescriptionOrdering = new ApiDescriptionLexicographicalOrdering();
    private ApiListingReferenceScanner apiListingReferenceScanner;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private Collection<RequestMappingReader> customAnnotationReaders;
    private boolean applyDefaultResponseMessages;

    public SwaggerSpringMvcPlugin(SpringSwaggerConfig springSwaggerConfig) {
        Assert.notNull((Object)springSwaggerConfig);
        this.springSwaggerConfig = springSwaggerConfig;
    }

    public SwaggerSpringMvcPlugin apiInfo(ApiInfo apiInfo) {
        this.apiInfo = apiInfo;
        return this;
    }

    public SwaggerSpringMvcPlugin authorizationTypes(List<AuthorizationType> authorizationTypes) {
        this.authorizationTypes = authorizationTypes;
        return this;
    }

    public SwaggerSpringMvcPlugin authorizationContext(AuthorizationContext authorizationContext) {
        this.authorizationContext = authorizationContext;
        return this;
    }

    public SwaggerSpringMvcPlugin swaggerGroup(String swaggerGroup) {
        this.swaggerGroup = swaggerGroup;
        return this;
    }

    public SwaggerSpringMvcPlugin pathProvider(SwaggerPathProvider swaggerPathProvider) {
        this.swaggerPathProvider = swaggerPathProvider;
        return this;
    }

    public SwaggerSpringMvcPlugin excludeAnnotations(Class<? extends Annotation> ... excludeAnnotations) {
        this.excludeAnnotations.addAll(Arrays.asList(excludeAnnotations));
        return this;
    }

    public SwaggerSpringMvcPlugin includePatterns(String ... includePatterns) {
        this.includePatterns = Arrays.asList(includePatterns);
        return this;
    }

    public SwaggerSpringMvcPlugin globalResponseMessage(RequestMethod requestMethod, List<ResponseMessage> responseMessages) {
        this.globalResponseMessages.put(requestMethod, responseMessages);
        return this;
    }

    public SwaggerSpringMvcPlugin ignoredParameterTypes(Class ... classes) {
        this.ignorableParameterTypes.addAll(Arrays.asList(classes));
        return this;
    }

    public SwaggerSpringMvcPlugin alternateTypeProvider(AlternateTypeProvider alternateTypeProvider) {
        this.alternateTypeProvider = alternateTypeProvider;
        return this;
    }

    public SwaggerSpringMvcPlugin apiVersion(String apiVersion) {
        Assert.hasText((String)apiVersion, (String)"apiVersion must contain text");
        this.apiVersion = apiVersion;
        return this;
    }

    public SwaggerSpringMvcPlugin modelProvider(ModelProvider modelProvider) {
        this.modelProvider = modelProvider;
        return this;
    }

    public SwaggerSpringMvcPlugin alternateTypeRules(AlternateTypeRule ... alternateTypeRules) {
        this.alternateTypeRules.addAll(Arrays.asList(alternateTypeRules));
        return this;
    }

    public SwaggerSpringMvcPlugin directModelSubstitute(Class clazz, Class with) {
        TypeResolver typeResolver = this.swaggerGlobalSettings.getTypeResolver();
        this.alternateTypeRules.add(Alternates.newRule((Type)typeResolver.resolve((Type)clazz, new Type[0]), (Type)typeResolver.resolve((Type)with, new Type[0])));
        return this;
    }

    public SwaggerSpringMvcPlugin useDefaultResponseMessages(boolean apply) {
        this.applyDefaultResponseMessages = apply;
        return this;
    }

    public SwaggerSpringMvcPlugin genericModelSubstitutes(Class ... genericClasses) {
        TypeResolver typeResolver = this.swaggerGlobalSettings.getTypeResolver();
        for (Class clz : genericClasses) {
            this.alternateTypeRules.add(Alternates.newRule((Type)typeResolver.resolve((Type)clz, new Type[]{WildcardType.class}), (Type)typeResolver.resolve(WildcardType.class, new Type[0])));
        }
        return this;
    }

    public SwaggerSpringMvcPlugin apiListingReferenceOrdering(Ordering<ApiListingReference> apiListingReferenceOrdering) {
        this.apiListingReferenceOrdering = apiListingReferenceOrdering;
        return this;
    }

    public SwaggerSpringMvcPlugin apiDescriptionOrdering(Ordering<ApiDescription> apiDescriptionOrdering) {
        this.apiDescriptionOrdering = apiDescriptionOrdering;
        return this;
    }

    public SwaggerSpringMvcPlugin resourceGroupingStrategy(ResourceGroupingStrategy resourceGroupingStrategy) {
        this.resourceGroupingStrategy = resourceGroupingStrategy;
        return this;
    }

    public SwaggerSpringMvcPlugin customAnnotationReaders(Collection<RequestMappingReader> customAnnotationReaders) {
        this.customAnnotationReaders = customAnnotationReaders;
        return this;
    }

    private ApiInfo defaultApiInfo() {
        return new ApiInfo(this.swaggerGroup + " Title", "Api Description", "Api terms of service", "Contact Email", "Licence Type", "License URL");
    }

    protected void initialize() {
        this.build().swaggerApiResourceListing.initialize();
    }

    public SwaggerSpringMvcPlugin build() {
        if (this.initialized.compareAndSet(false, true)) {
            this.configure();
            this.buildSwaggerGlobalSettings();
            this.buildApiListingReferenceScanner();
            this.buildSwaggerApiResourceListing();
        }
        return this;
    }

    private void configure() {
        if (StringUtils.isBlank((String)this.swaggerGroup)) {
            this.swaggerGroup = "default";
        }
        if (null == this.apiInfo) {
            this.apiInfo = this.defaultApiInfo();
        }
        if (null == this.resourceGroupingStrategy) {
            this.resourceGroupingStrategy = this.springSwaggerConfig.defaultResourceGroupingStrategy();
        }
        if (null == this.includePatterns || this.includePatterns.size() == 0) {
            this.includePatterns = Arrays.asList(".*?");
        }
        if (null == this.swaggerPathProvider) {
            this.swaggerPathProvider = this.springSwaggerConfig.defaultSwaggerPathProvider();
        }
        if (null == this.alternateTypeProvider) {
            this.alternateTypeProvider = this.springSwaggerConfig.defaultAlternateTypeProvider();
        }
        if (null == this.modelProvider) {
            this.modelProvider = this.springSwaggerConfig.defaultModelProvider();
        }
        if (null == this.customAnnotationReaders) {
            this.customAnnotationReaders = Lists.newArrayList();
        }
    }

    private void buildSwaggerGlobalSettings() {
        HashMap mergedResponseMessages = Maps.newHashMap();
        if (this.applyDefaultResponseMessages) {
            mergedResponseMessages.putAll(this.springSwaggerConfig.defaultResponseMessages());
        }
        mergedResponseMessages.putAll(this.globalResponseMessages);
        this.swaggerGlobalSettings.setGlobalResponseMessages(mergedResponseMessages);
        HashSet<Class> mergedIgnorableParameterTypes = new HashSet<Class>();
        mergedIgnorableParameterTypes.addAll(this.springSwaggerConfig.defaultIgnorableParameterTypes());
        mergedIgnorableParameterTypes.addAll(this.ignorableParameterTypes);
        this.swaggerGlobalSettings.setIgnorableParameterTypes(mergedIgnorableParameterTypes);
        for (AlternateTypeRule rule : this.alternateTypeRules) {
            this.alternateTypeProvider.addRule(rule);
        }
        this.swaggerGlobalSettings.setAlternateTypeProvider(this.alternateTypeProvider);
    }

    private void buildSwaggerApiResourceListing() {
        this.swaggerApiResourceListing = new SwaggerApiResourceListing(this.springSwaggerConfig.swaggerCache(), this.swaggerGroup);
        this.swaggerApiResourceListing.setSwaggerGlobalSettings(this.swaggerGlobalSettings);
        this.swaggerApiResourceListing.setSwaggerPathProvider(this.swaggerPathProvider);
        this.swaggerApiResourceListing.setApiInfo(this.apiInfo);
        this.swaggerApiResourceListing.setAuthorizationTypes(this.authorizationTypes);
        this.swaggerApiResourceListing.setAuthorizationContext(this.authorizationContext);
        this.swaggerApiResourceListing.setModelProvider(this.modelProvider);
        this.swaggerApiResourceListing.setApiListingReferenceScanner(this.apiListingReferenceScanner);
        this.swaggerApiResourceListing.setApiVersion(this.apiVersion);
        this.swaggerApiResourceListing.setApiListingReferenceOrdering(this.apiListingReferenceOrdering);
        this.swaggerApiResourceListing.setApiDescriptionOrdering(this.apiDescriptionOrdering);
        this.swaggerApiResourceListing.setCustomAnnotationReaders(this.customAnnotationReaders);
    }

    private ApiListingReferenceScanner buildApiListingReferenceScanner() {
        List<Class<? extends Annotation>> mergedExcludedAnnotations = this.springSwaggerConfig.defaultExcludeAnnotations();
        mergedExcludedAnnotations.addAll(this.excludeAnnotations);
        this.apiListingReferenceScanner = new ApiListingReferenceScanner();
        this.apiListingReferenceScanner.setRequestMappingHandlerMapping(this.springSwaggerConfig.swaggerRequestMappingHandlerMappings());
        this.apiListingReferenceScanner.setExcludeAnnotations(mergedExcludedAnnotations);
        this.apiListingReferenceScanner.setResourceGroupingStrategy(this.resourceGroupingStrategy);
        this.apiListingReferenceScanner.setSwaggerPathProvider(this.swaggerPathProvider);
        this.apiListingReferenceScanner.setSwaggerGroup(this.swaggerGroup);
        this.apiListingReferenceScanner.setIncludePatterns(this.includePatterns);
        return this.apiListingReferenceScanner;
    }
}

