/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.readers;

import com.google.common.collect.Lists;
import com.mangofactory.swagger.ScalaUtils;
import com.mangofactory.swagger.paths.SwaggerPathProvider;
import com.mangofactory.swagger.readers.ApiOperationReader;
import com.mangofactory.swagger.readers.Command;
import com.mangofactory.swagger.readers.operation.RequestMappingReader;
import com.mangofactory.swagger.scanners.RequestMappingContext;
import com.wordnik.swagger.model.ApiDescription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public class ApiDescriptionReader
implements Command<RequestMappingContext> {
    private final SwaggerPathProvider swaggerPathProvider;
    private Collection<RequestMappingReader> customAnnotationReaders;

    public ApiDescriptionReader(SwaggerPathProvider pathProvider, Collection<RequestMappingReader> customAnnotationReaders) {
        this.swaggerPathProvider = pathProvider;
        this.customAnnotationReaders = customAnnotationReaders;
    }

    @Override
    public void execute(RequestMappingContext context) {
        RequestMappingInfo requestMappingInfo = context.getRequestMappingInfo();
        HandlerMethod handlerMethod = context.getHandlerMethod();
        PatternsRequestCondition patternsCondition = requestMappingInfo.getPatternsCondition();
        ArrayList apiDescriptionList = Lists.newArrayList();
        for (String pattern : patternsCondition.getPatterns()) {
            String cleanedRequestMappingPath = this.sanitizeRequestMappingPattern(pattern);
            String path = this.swaggerPathProvider.getOperationPath(cleanedRequestMappingPath);
            String methodName = handlerMethod.getMethod().getName();
            context.put("requestMappingPattern", cleanedRequestMappingPath);
            ApiOperationReader apiOperationReader = new ApiOperationReader(this.customAnnotationReaders);
            apiOperationReader.execute(context);
            List operations = (List)context.get("operations");
            apiDescriptionList.add(new ApiDescription(path, ScalaUtils.toOption(methodName), ScalaUtils.toScalaList(operations), false));
        }
        context.put("apiDescriptionList", apiDescriptionList);
    }

    public String sanitizeRequestMappingPattern(String requestMappingPattern) {
        String result = requestMappingPattern;
        return (result = result.replaceAll("\\{([^}]*?):.*?\\}", "{$1}")).isEmpty() ? "/" : result;
    }
}

