/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.readers.operation.parameter;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.mangofactory.swagger.models.ResolvedTypes;
import com.mangofactory.swagger.models.Types;
import com.mangofactory.swagger.models.alternates.AlternateTypeProvider;
import com.mangofactory.swagger.readers.operation.parameter.ParameterBuilder;
import com.wordnik.swagger.model.Parameter;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ModelAttributeParameterExpander {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelAttributeParameterExpander.class);
    private AlternateTypeProvider alternateTypeProvider;
    private TypeResolver resolver = new TypeResolver();

    public ModelAttributeParameterExpander(AlternateTypeProvider alternateTypeProvider) {
        this.alternateTypeProvider = alternateTypeProvider;
    }

    public void expand(String parentName, Class<?> paramType, List<Parameter> parameters) {
        Set<String> beanPropNames = this.getBeanPropertyNames(paramType);
        List<Field> fields = this.getAllFields(paramType);
        LOGGER.debug("Expanding parameter type: {}", paramType);
        for (Field field : fields) {
            LOGGER.debug("Attempting to expanding field: {}", (Object)field);
            if (Modifier.isStatic(field.getModifiers()) || field.isSynthetic() || !beanPropNames.contains(field.getName())) {
                LOGGER.debug("Skipping expansion of field: {}, not a valid bean property", (Object)field);
                continue;
            }
            Class<?> resolvedType = this.getResolvedType(field);
            if (!this.typeBelongsToJavaPackage(resolvedType) && !resolvedType.isEnum()) {
                LOGGER.debug("Expanding complex field: {} with type: {}", (Object)field, resolvedType);
                this.expand(field.getName(), field.getType(), parameters);
                continue;
            }
            String dataTypeName = Types.typeNameFor(resolvedType);
            if (dataTypeName == null) {
                dataTypeName = resolvedType.getSimpleName();
            }
            LOGGER.debug("Building parameter for field: {}, with type: ", (Object)field, resolvedType);
            parameters.add(new ParameterBuilder().forField(field).withDataTypeName(dataTypeName).withParentName(parentName).build());
        }
    }

    private Class<?> getResolvedType(Field field) {
        ResolvedType resolvedType;
        ResolvedType alternativeType;
        Class erasedType;
        Class<?> type = field.getType();
        if (type != (erasedType = (alternativeType = this.alternateTypeProvider.alternateFor(resolvedType = ResolvedTypes.asResolved((TypeResolver)this.resolver, type))).getErasedType())) {
            LOGGER.debug("Found alternative type [{}] for field: [{}-{}]", new Object[]{erasedType, field, type});
        }
        return erasedType;
    }

    private boolean typeBelongsToJavaPackage(Class<?> type) {
        return type.getPackage() == null || type.getPackage().getName().startsWith("java") || Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type);
    }

    private List<Field> getAllFields(Class<?> type) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Class<?> i = type; i != null && i != Object.class; i = i.getSuperclass()) {
            result.addAll(Arrays.asList(i.getDeclaredFields()));
        }
        return result;
    }

    private Set<String> getBeanPropertyNames(Class<?> clazz) {
        try {
            HashSet<String> beanProps = new HashSet<String>();
            PropertyDescriptor[] propDescriptors = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
            for (int i = 0; i < propDescriptors.length; ++i) {
                if (propDescriptors[i].getReadMethod() == null || propDescriptors[i].getWriteMethod() == null) continue;
                beanProps.add(propDescriptors[i].getName());
            }
            return beanProps;
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Failed to get bean properties on " + clazz, e);
        }
    }
}

