/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.plugin;

import com.mangofactory.swagger.configuration.SpringSwaggerConfig;
import com.mangofactory.swagger.plugin.SwaggerSpringMvcPlugin;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class SwaggerPluginAdapter
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(SwaggerPluginAdapter.class);
    private SpringSwaggerConfig springSwaggerConfig;
    private boolean initialized = false;

    public SwaggerPluginAdapter(SpringSwaggerConfig springSwaggerConfig) {
        this.springSwaggerConfig = springSwaggerConfig;
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        if (!this.initialized) {
            log.info("Context refreshed");
            ApplicationContext applicationContext = contextRefreshedEvent.getApplicationContext();
            Map plugins = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)applicationContext, SwaggerSpringMvcPlugin.class);
            if (plugins.isEmpty()) {
                log.info("Did not find any SwaggerSpringMvcPlugins so creating a default one");
                new SwaggerSpringMvcPlugin(this.springSwaggerConfig).build().initialize();
            } else {
                log.info("Found custom SwaggerSpringMvcPlugins");
                for (Map.Entry entry : plugins.entrySet()) {
                    if (((SwaggerSpringMvcPlugin)entry.getValue()).isEnabled()) {
                        log.info("initializing plugin bean {}", entry.getKey());
                        ((SwaggerSpringMvcPlugin)entry.getValue()).build().initialize();
                        continue;
                    }
                    log.info("Skipping initializing disabled plugin bean {}", entry.getKey());
                }
            }
            this.initialized = true;
        } else {
            log.warn("SwaggerSpringMvcPlugin have already been initialized!");
        }
    }
}

