/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.readers.operation.parameter;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mangofactory.swagger.ScalaUtils;
import com.mangofactory.swagger.models.Annotations;
import com.mangofactory.swagger.readers.operation.parameter.ParameterAllowableReader;
import com.wordnik.swagger.annotations.ApiModelProperty;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.model.AllowableListValues;
import com.wordnik.swagger.model.AllowableValues;
import com.wordnik.swagger.model.Parameter;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import scala.collection.JavaConversions;

class ParameterBuilder {
    private String dataTypeName;
    private String parentName;
    private Field field;

    ParameterBuilder() {
    }

    public ParameterBuilder withDataTypeName(String dataTypeName) {
        this.dataTypeName = dataTypeName;
        return this;
    }

    public ParameterBuilder withParentName(String parentName) {
        this.parentName = parentName;
        return this;
    }

    public ParameterBuilder forField(Field field) {
        this.field = field;
        return this;
    }

    public Parameter build() {
        Optional apiModelPropertyOptional = Annotations.findApiModePropertyAnnotation((AnnotatedElement)this.field);
        if (apiModelPropertyOptional.isPresent()) {
            return this.fromApiModelProperty((ApiModelProperty)apiModelPropertyOptional.get());
        }
        Optional apiParamOptional = Annotations.findApiParamAnnotation((AnnotatedElement)this.field);
        if (apiParamOptional.isPresent()) {
            return this.fromApiParam((ApiParam)apiParamOptional.get());
        }
        return this.defaultParameter();
    }

    private Parameter defaultParameter() {
        AllowableValues allowable = this.allowableValues((Optional<String>)Optional.absent(), this.field);
        return new Parameter(Strings.isNullOrEmpty((String)this.parentName) ? this.field.getName() : String.format("%s.%s", this.parentName, this.field.getName()), ScalaUtils.toOption(null), ScalaUtils.toOption(null), Boolean.FALSE.booleanValue(), Boolean.FALSE.booleanValue(), this.dataTypeName, allowable, "query", ScalaUtils.toOption(null));
    }

    private Parameter fromApiParam(ApiParam apiParam) {
        String allowableProperty = Strings.emptyToNull((String)apiParam.allowableValues());
        AllowableValues allowable = this.allowableValues((Optional<String>)Optional.fromNullable((Object)allowableProperty), this.field);
        return new Parameter(Strings.isNullOrEmpty((String)this.parentName) ? this.field.getName() : String.format("%s.%s", this.parentName, this.field.getName()), ScalaUtils.toOption(apiParam.value()), ScalaUtils.toOption(apiParam.defaultValue()), apiParam.required(), apiParam.allowMultiple(), this.dataTypeName, allowable, "query", ScalaUtils.toOption(apiParam.access()));
    }

    private Parameter fromApiModelProperty(ApiModelProperty apiModelProperty) {
        String allowableProperty = Strings.emptyToNull((String)apiModelProperty.allowableValues());
        AllowableValues allowable = this.allowableValues((Optional<String>)Optional.fromNullable((Object)allowableProperty), this.field);
        return new Parameter(Strings.isNullOrEmpty((String)this.parentName) ? this.field.getName() : String.format("%s.%s", this.parentName, this.field.getName()), ScalaUtils.toOption(apiModelProperty.value()), ScalaUtils.toOption(null), apiModelProperty.required(), Boolean.FALSE.booleanValue(), this.dataTypeName, allowable, "query", ScalaUtils.toOption(apiModelProperty.access()));
    }

    private AllowableValues allowableValues(Optional<String> optionalAllowable, Field field) {
        AllowableValues allowable = null;
        if (field.getType().isEnum()) {
            allowable = new AllowableListValues(JavaConversions.collectionAsScalaIterable(this.getEnumValues(field.getType())).toList(), "LIST");
        } else if (optionalAllowable.isPresent()) {
            allowable = ParameterAllowableReader.allowableValueFromString((String)optionalAllowable.get());
        }
        return allowable;
    }

    private List<String> getEnumValues(Class<?> subject) {
        return Lists.transform(Arrays.asList(subject.getEnumConstants()), (Function)new Function<Object, String>(){

            public String apply(Object input) {
                return input.toString();
            }
        });
    }
}

