/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.readers.operation.parameter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.mangofactory.swagger.readers.Command;
import com.mangofactory.swagger.readers.operation.parameter.ParameterAnnotationReader;
import com.mangofactory.swagger.scanners.RequestMappingContext;
import com.wordnik.swagger.annotations.ApiParam;
import java.lang.annotation.Annotation;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

public class ParameterNameReader
implements Command<RequestMappingContext> {
    private ParameterAnnotationReader annotations = new ParameterAnnotationReader();

    public ParameterNameReader() {
    }

    @VisibleForTesting
    ParameterNameReader(ParameterAnnotationReader annotations) {
        this.annotations = annotations;
    }

    @Override
    public void execute(RequestMappingContext context) {
        String name;
        MethodParameter methodParameter = (MethodParameter)context.get("methodParameter");
        Optional apiParam = Optional.fromNullable((Object)methodParameter.getParameterAnnotation(ApiParam.class));
        if ((apiParam = apiParam.or(this.annotations.fromHierarchy(methodParameter, ApiParam.class))).isPresent() && !StringUtils.isBlank((String)((ApiParam)apiParam.get()).name())) {
            name = ((ApiParam)apiParam.get()).name();
        } else {
            name = this.findParameterNameFromAnnotations(methodParameter);
            if (Strings.isNullOrEmpty((String)name)) {
                String parameterName = methodParameter.getParameterName();
                name = Strings.isNullOrEmpty((String)parameterName) ? String.format("param%s", methodParameter.getParameterIndex()) : parameterName;
            }
        }
        context.put("name", name);
    }

    private String findParameterNameFromAnnotations(MethodParameter methodParameter) {
        Annotation[] methodAnnotations = methodParameter.getParameterAnnotations();
        if (null != methodAnnotations) {
            for (Annotation annotation : methodAnnotations) {
                if (annotation instanceof PathVariable) {
                    return ((PathVariable)annotation).value();
                }
                if (annotation instanceof ModelAttribute) {
                    return ((ModelAttribute)annotation).value();
                }
                if (annotation instanceof RequestParam) {
                    return ((RequestParam)annotation).value();
                }
                if (!(annotation instanceof RequestHeader)) continue;
                return ((RequestHeader)annotation).value();
            }
        }
        return null;
    }
}

