/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.configuration;

import com.fasterxml.classmate.TypeResolver;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mangofactory.swagger.annotations.ApiIgnore;
import com.mangofactory.swagger.configuration.JacksonSwaggerSupport;
import com.mangofactory.swagger.core.ClassOrApiAnnotationResourceGrouping;
import com.mangofactory.swagger.core.ResourceGroupingStrategy;
import com.mangofactory.swagger.core.SwaggerCache;
import com.mangofactory.swagger.models.ModelProvider;
import com.mangofactory.swagger.models.alternates.AlternateTypeProvider;
import com.mangofactory.swagger.models.configuration.SwaggerModelsConfiguration;
import com.mangofactory.swagger.models.dto.ResponseMessage;
import com.mangofactory.swagger.models.dto.builder.ResponseMessageBuilder;
import com.mangofactory.swagger.paths.RelativeSwaggerPathProvider;
import com.mangofactory.swagger.paths.SwaggerPathProvider;
import com.mangofactory.swagger.plugin.SwaggerPluginAdapter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
@ComponentScan(basePackages={"com.mangofactory.swagger.controllers"})
@Import(value={SwaggerModelsConfiguration.class})
public class SpringSwaggerConfig {
    @Autowired
    private List<RequestMappingHandlerMapping> handlerMappings;
    @Autowired
    private ServletContext servletContext;
    @Autowired
    private ModelProvider modelProvider;
    @Autowired
    private AlternateTypeProvider alternateTypeProvider;
    @Autowired
    private TypeResolver typeResolver;

    @Bean
    public List<RequestMappingHandlerMapping> swaggerRequestMappingHandlerMappings() {
        return this.handlerMappings;
    }

    @Bean
    public ResourceGroupingStrategy defaultResourceGroupingStrategy() {
        return new ClassOrApiAnnotationResourceGrouping();
    }

    @Bean
    public List<Class<? extends Annotation>> defaultExcludeAnnotations() {
        ArrayList<Class<? extends Annotation>> annotations = new ArrayList<Class<? extends Annotation>>();
        annotations.add(ApiIgnore.class);
        return annotations;
    }

    @Bean
    public SwaggerPathProvider defaultSwaggerPathProvider() {
        return new RelativeSwaggerPathProvider(this.servletContext);
    }

    @Bean
    public SwaggerCache swaggerCache() {
        return new SwaggerCache();
    }

    @Bean
    public Set<Class> defaultIgnorableParameterTypes() {
        HashSet ignored = Sets.newHashSet();
        ignored.add(ServletRequest.class);
        ignored.add(HttpHeaders.class);
        ignored.add(ServletResponse.class);
        ignored.add(HttpServletRequest.class);
        ignored.add(HttpServletResponse.class);
        ignored.add(HttpHeaders.class);
        ignored.add(BindingResult.class);
        ignored.add(ServletContext.class);
        ignored.add(UriComponentsBuilder.class);
        ignored.add(ApiIgnore.class);
        return ignored;
    }

    public AlternateTypeProvider defaultAlternateTypeProvider() {
        return this.alternateTypeProvider;
    }

    @Bean
    public Map<RequestMethod, List<ResponseMessage>> defaultResponseMessages() {
        LinkedHashMap responses = Maps.newLinkedHashMap();
        responses.put(RequestMethod.GET, this.asList(new ResponseMessageBuilder().code(HttpStatus.OK.value()).message(HttpStatus.OK.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.NOT_FOUND.value()).message(HttpStatus.NOT_FOUND.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.FORBIDDEN.value()).message(HttpStatus.FORBIDDEN.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.UNAUTHORIZED.value()).message(HttpStatus.UNAUTHORIZED.getReasonPhrase()).responseModel(null).build()));
        responses.put(RequestMethod.PUT, this.asList(new ResponseMessageBuilder().code(HttpStatus.CREATED.value()).message(HttpStatus.CREATED.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.NOT_FOUND.value()).message(HttpStatus.NOT_FOUND.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.FORBIDDEN.value()).message(HttpStatus.FORBIDDEN.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.UNAUTHORIZED.value()).message(HttpStatus.UNAUTHORIZED.getReasonPhrase()).responseModel(null).build()));
        responses.put(RequestMethod.POST, this.asList(new ResponseMessageBuilder().code(HttpStatus.CREATED.value()).message(HttpStatus.CREATED.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.NOT_FOUND.value()).message(HttpStatus.NOT_FOUND.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.FORBIDDEN.value()).message(HttpStatus.FORBIDDEN.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.UNAUTHORIZED.value()).message(HttpStatus.UNAUTHORIZED.getReasonPhrase()).responseModel(null).build()));
        responses.put(RequestMethod.DELETE, this.asList(new ResponseMessageBuilder().code(HttpStatus.NO_CONTENT.value()).message(HttpStatus.NO_CONTENT.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.FORBIDDEN.value()).message(HttpStatus.FORBIDDEN.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.UNAUTHORIZED.value()).message(HttpStatus.UNAUTHORIZED.getReasonPhrase()).responseModel(null).build()));
        responses.put(RequestMethod.PATCH, this.asList(new ResponseMessageBuilder().code(HttpStatus.NO_CONTENT.value()).message(HttpStatus.NO_CONTENT.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.FORBIDDEN.value()).message(HttpStatus.FORBIDDEN.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.UNAUTHORIZED.value()).message(HttpStatus.UNAUTHORIZED.getReasonPhrase()).responseModel(null).build()));
        responses.put(RequestMethod.TRACE, this.asList(new ResponseMessageBuilder().code(HttpStatus.NO_CONTENT.value()).message(HttpStatus.NO_CONTENT.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.FORBIDDEN.value()).message(HttpStatus.FORBIDDEN.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.UNAUTHORIZED.value()).message(HttpStatus.UNAUTHORIZED.getReasonPhrase()).responseModel(null).build()));
        responses.put(RequestMethod.OPTIONS, this.asList(new ResponseMessageBuilder().code(HttpStatus.NO_CONTENT.value()).message(HttpStatus.NO_CONTENT.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.FORBIDDEN.value()).message(HttpStatus.FORBIDDEN.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.UNAUTHORIZED.value()).message(HttpStatus.UNAUTHORIZED.getReasonPhrase()).responseModel(null).build()));
        responses.put(RequestMethod.HEAD, this.asList(new ResponseMessageBuilder().code(HttpStatus.NO_CONTENT.value()).message(HttpStatus.NO_CONTENT.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.FORBIDDEN.value()).message(HttpStatus.FORBIDDEN.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.UNAUTHORIZED.value()).message(HttpStatus.UNAUTHORIZED.getReasonPhrase()).responseModel(null).build()));
        return responses;
    }

    @Bean
    public SwaggerPluginAdapter swaggerPluginAdapter() {
        return new SwaggerPluginAdapter(this);
    }

    public ModelProvider defaultModelProvider() {
        return this.modelProvider;
    }

    private List<ResponseMessage> asList(ResponseMessage ... responseMessages) {
        ArrayList<ResponseMessage> list = new ArrayList<ResponseMessage>();
        for (ResponseMessage responseMessage : responseMessages) {
            list.add(responseMessage);
        }
        return list;
    }

    @Bean
    public JacksonSwaggerSupport jacksonSwaggerSupport() {
        return new JacksonSwaggerSupport();
    }
}

