/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.readers;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mangofactory.swagger.configuration.SwaggerGlobalSettings;
import com.mangofactory.swagger.core.ModelUtils;
import com.mangofactory.swagger.models.Annotations;
import com.mangofactory.swagger.models.ModelContext;
import com.mangofactory.swagger.models.ModelProvider;
import com.mangofactory.swagger.models.ResolvedTypes;
import com.mangofactory.swagger.models.dto.Model;
import com.mangofactory.swagger.models.dto.builder.ModelBuilder;
import com.mangofactory.swagger.readers.Command;
import com.mangofactory.swagger.readers.operation.HandlerMethodResolver;
import com.mangofactory.swagger.readers.operation.ResolvedMethodParameter;
import com.mangofactory.swagger.scanners.RequestMappingContext;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.method.HandlerMethod;

@Component
public class ApiModelReader
implements Command<RequestMappingContext> {
    private static final Logger log = LoggerFactory.getLogger(ApiModelReader.class);
    private ModelProvider modelProvider;

    @Autowired
    public ApiModelReader(ModelProvider modelProvider) {
        this.modelProvider = modelProvider;
    }

    @Override
    public void execute(RequestMappingContext context) {
        HandlerMethod handlerMethod = context.getHandlerMethod();
        log.debug("Reading models for handlerMethod |{}|", (Object)handlerMethod.getMethod().getName());
        HashMap modelMap = Maps.newHashMap();
        SwaggerGlobalSettings swaggerGlobalSettings = (SwaggerGlobalSettings)context.get("swaggerGlobalSettings");
        HandlerMethodResolver handlerMethodResolver = new HandlerMethodResolver(swaggerGlobalSettings.getTypeResolver());
        ResolvedType modelType = ModelUtils.handlerReturnType(swaggerGlobalSettings.getTypeResolver(), handlerMethod);
        modelType = swaggerGlobalSettings.getAlternateTypeProvider().alternateFor(modelType);
        ApiOperation apiOperationAnnotation = (ApiOperation)handlerMethod.getMethodAnnotation(ApiOperation.class);
        if (null != apiOperationAnnotation && Void.class != apiOperationAnnotation.response()) {
            modelType = ResolvedTypes.asResolved((TypeResolver)swaggerGlobalSettings.getTypeResolver(), (Type)apiOperationAnnotation.response());
        }
        if (!swaggerGlobalSettings.getIgnorableParameterTypes().contains(modelType.getErasedType())) {
            ModelContext modelContext = ModelContext.returnValue((Type)modelType);
            this.markIgnorablesAsHasSeen(swaggerGlobalSettings.getTypeResolver(), swaggerGlobalSettings.getIgnorableParameterTypes(), modelContext);
            Optional model = this.modelProvider.modelFor(modelContext);
            if (model.isPresent() && !"void".equals(((Model)model.get()).getName())) {
                log.debug("Swagger generated parameter model id: {}, name: {}, schema: {} models", (Object)((Model)model.get()).getId(), (Object)((Model)model.get()).getName());
                modelMap.put(((Model)model.get()).getId(), model.get());
            } else {
                log.debug("Swagger core did not find any models");
            }
            this.populateDependencies(modelContext, modelMap);
        }
        this.mergeModelMap(modelMap, this.readParametersApiModel(handlerMethodResolver, swaggerGlobalSettings, handlerMethod));
        this.mergeModelMap(modelMap, this.readApiResponses(swaggerGlobalSettings, handlerMethod));
        log.debug("Finished reading models for handlerMethod |{}|", (Object)handlerMethod.getMethod().getName());
        context.put("models", modelMap);
    }

    private Map<String, Model> readApiResponses(SwaggerGlobalSettings settings, HandlerMethod handlerMethod) {
        Optional apiResponses = Annotations.findApiResponsesAnnotations((AnnotatedElement)handlerMethod.getMethod());
        HashMap modelMap = Maps.newHashMap();
        log.debug("Reading parameters models for handlerMethod |{}|", (Object)handlerMethod.getMethod().getName());
        if (!apiResponses.isPresent()) {
            return modelMap;
        }
        for (ApiResponse response : ((ApiResponses)apiResponses.get()).value()) {
            if (settings.getIgnorableParameterTypes().contains(response.response())) continue;
            ResolvedType modelType = settings.getAlternateTypeProvider().alternateFor(ResolvedTypes.asResolved((TypeResolver)new TypeResolver(), (Type)response.response()));
            ModelContext modelContext = ModelContext.inputParam((Type)modelType);
            this.markIgnorablesAsHasSeen(settings.getTypeResolver(), settings.getIgnorableParameterTypes(), modelContext);
            Optional pModel = this.modelProvider.modelFor(modelContext);
            if (pModel.isPresent()) {
                log.debug("Swagger generated parameter model id: {}, name: {}, schema: {} models", (Object)((Model)pModel.get()).getId(), (Object)((Model)pModel.get()).getName());
                modelMap.put(((Model)pModel.get()).getId(), pModel.get());
            } else {
                log.debug("Swagger core did not find any parameter models for {}", (Object)response.response());
            }
            this.populateDependencies(modelContext, modelMap);
        }
        log.debug("Finished reading parameters models for handlerMethod |{}|", (Object)handlerMethod.getMethod().getName());
        return modelMap;
    }

    private void mergeModelMap(Map<String, Model> target, Map<String, Model> source) {
        for (Map.Entry<String, Model> sModelEntry : source.entrySet()) {
            String sourceModelKey = sModelEntry.getKey();
            if (!target.containsKey(sourceModelKey)) {
                target.put(sModelEntry.getKey(), sModelEntry.getValue());
                continue;
            }
            Model targetModelValue = target.get(sourceModelKey);
            Model sourceModelValue = sModelEntry.getValue();
            Map targetProperties = targetModelValue.getProperties();
            Map sourceProperties = sourceModelValue.getProperties();
            HashSet newSourcePropKeys = Sets.newHashSet(sourceProperties.keySet());
            newSourcePropKeys.removeAll(targetProperties.keySet());
            HashMap mergedTargetProperties = Maps.newHashMap((Map)targetProperties);
            for (String newProperty : newSourcePropKeys) {
                mergedTargetProperties.put(newProperty, sourceProperties.get(newProperty));
            }
            Model mergedModel = new ModelBuilder().id(targetModelValue.getId()).name(targetModelValue.getName()).qualifiedType(targetModelValue.getQualifiedType()).properties((Map)mergedTargetProperties).description(targetModelValue.getDescription()).baseModel(targetModelValue.getBaseModel()).discriminator(targetModelValue.getDiscriminator()).subTypes(targetModelValue.getSubTypes()).build();
            target.put(sourceModelKey, mergedModel);
        }
    }

    private void markIgnorablesAsHasSeen(TypeResolver typeResolver, Set<Class> ignorableParameterTypes, ModelContext modelContext) {
        for (Class ignorableParameterType : ignorableParameterTypes) {
            modelContext.seen(ResolvedTypes.asResolved((TypeResolver)typeResolver, (Type)ignorableParameterType));
        }
    }

    private Map<String, Model> readParametersApiModel(HandlerMethodResolver handlerMethodResolver, SwaggerGlobalSettings settings, HandlerMethod handlerMethod) {
        Method method = handlerMethod.getMethod();
        HashMap modelMap = Maps.newHashMap();
        log.debug("Reading parameters models for handlerMethod |{}|", (Object)handlerMethod.getMethod().getName());
        List<ResolvedMethodParameter> parameterTypes = handlerMethodResolver.methodParameters(handlerMethod);
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            Annotation[] pAnnotations;
            for (Annotation annotation : pAnnotations = annotations[i]) {
                if (!(annotation instanceof RequestBody)) continue;
                ResolvedMethodParameter pType = parameterTypes.get(i);
                if (settings.getIgnorableParameterTypes().contains(pType.getResolvedParameterType().getErasedType())) continue;
                ResolvedType modelType = settings.getAlternateTypeProvider().alternateFor(pType.getResolvedParameterType());
                ModelContext modelContext = ModelContext.inputParam((Type)modelType);
                this.markIgnorablesAsHasSeen(settings.getTypeResolver(), settings.getIgnorableParameterTypes(), modelContext);
                Optional pModel = this.modelProvider.modelFor(modelContext);
                if (pModel.isPresent()) {
                    log.debug("Swagger generated parameter model id: {}, name: {}, schema: {} models", (Object)((Model)pModel.get()).getId(), (Object)((Model)pModel.get()).getName());
                    modelMap.put(((Model)pModel.get()).getId(), pModel.get());
                } else {
                    log.debug("Swagger core did not find any parameter models for {}", (Object)pType.getResolvedParameterType());
                }
                this.populateDependencies(modelContext, modelMap);
            }
        }
        log.debug("Finished reading parameters models for handlerMethod |{}|", (Object)handlerMethod.getMethod().getName());
        return modelMap;
    }

    private void populateDependencies(ModelContext modelContext, Map<String, Model> modelMap) {
        modelMap.putAll(this.modelProvider.dependencies(modelContext));
    }
}

