/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import com.mangofactory.swagger.configuration.SwaggerGlobalSettings;
import com.mangofactory.swagger.core.ModelUtils;
import com.mangofactory.swagger.models.Annotations;
import com.mangofactory.swagger.models.ResolvedTypes;
import com.mangofactory.swagger.models.dto.ResponseMessage;
import com.mangofactory.swagger.models.dto.builder.ResponseMessageBuilder;
import com.mangofactory.swagger.readers.operation.SwaggerResponseMessageReader;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.method.HandlerMethod;

public class DefaultResponseMessageReader
extends SwaggerResponseMessageReader {
    @Override
    protected Collection<ResponseMessage> read(SwaggerGlobalSettings swaggerGlobalSettings, RequestMethod currentHttpMethod, HandlerMethod handlerMethod) {
        List<ResponseMessage> responseMessages = this.globalResponseMessages(swaggerGlobalSettings, currentHttpMethod);
        HashMap byStatusCode = Maps.newHashMap((Map)Maps.uniqueIndex(responseMessages, this.byStatusCode()));
        this.applyAnnotatedOverrides(swaggerGlobalSettings, handlerMethod, byStatusCode);
        this.applyReturnTypeOverride(swaggerGlobalSettings, handlerMethod, byStatusCode);
        return Ordering.from(this.responseMessageComparer()).sortedCopy(byStatusCode.values());
    }

    private Comparator<ResponseMessage> responseMessageComparer() {
        return new Comparator<ResponseMessage>(){

            @Override
            public int compare(ResponseMessage first, ResponseMessage second) {
                return Ints.compare((int)first.getCode(), (int)second.getCode());
            }
        };
    }

    private void applyReturnTypeOverride(SwaggerGlobalSettings swaggerGlobalSettings, HandlerMethod handlerMethod, Map<Integer, ResponseMessage> byStatusCode) {
        ResolvedType returnType = ModelUtils.handlerReturnType(swaggerGlobalSettings.getTypeResolver(), handlerMethod);
        returnType = swaggerGlobalSettings.getAlternateTypeProvider().alternateFor(returnType);
        int httpStatusCode = this.httpStatusCode(handlerMethod);
        ResponseMessage responseMessage = byStatusCode.get(httpStatusCode);
        String message = null;
        if (responseMessage != null) {
            message = this.coalese(responseMessage.getMessage(), HttpStatus.OK.getReasonPhrase());
        }
        String simpleName = null;
        if (!Void.class.equals((Object)returnType.getErasedType()) && !Void.TYPE.equals(returnType.getErasedType())) {
            simpleName = ResolvedTypes.typeName((ResolvedType)returnType);
        }
        ResponseMessage responseWithModel = new ResponseMessageBuilder().code(httpStatusCode).message(message).responseModel(simpleName).build();
        byStatusCode.put(httpStatusCode, responseWithModel);
    }

    private int httpStatusCode(HandlerMethod handlerMethod) {
        Optional responseStatus = Optional.fromNullable((Object)AnnotationUtils.getAnnotation((Method)handlerMethod.getMethod(), ResponseStatus.class));
        int httpStatusCode = 200;
        if (responseStatus.isPresent()) {
            httpStatusCode = ((ResponseStatus)responseStatus.get()).value().value();
        }
        return httpStatusCode;
    }

    private void applyAnnotatedOverrides(SwaggerGlobalSettings swaggerGlobalSettings, HandlerMethod handlerMethod, Map<Integer, ResponseMessage> byStatusCode) {
        Optional apiResponsesOptional = Annotations.findApiResponsesAnnotations((AnnotatedElement)handlerMethod.getMethod());
        if (apiResponsesOptional.isPresent()) {
            ApiResponse[] apiResponseAnnotations;
            for (ApiResponse apiResponse : apiResponseAnnotations = ((ApiResponses)apiResponsesOptional.get()).value()) {
                String overrideTypeName = this.overrideTypeName(swaggerGlobalSettings, apiResponse);
                ResponseMessage responseMessage = byStatusCode.get(apiResponse.code());
                if (null == responseMessage) {
                    byStatusCode.put(apiResponse.code(), new ResponseMessageBuilder().code(apiResponse.code()).message(apiResponse.message()).responseModel(overrideTypeName).build());
                    continue;
                }
                String responseModel = responseMessage.getResponseModel();
                if (!Strings.isNullOrEmpty((String)overrideTypeName)) {
                    responseModel = overrideTypeName;
                }
                byStatusCode.put(apiResponse.code(), new ResponseMessageBuilder().code(apiResponse.code()).message(this.coalese(apiResponse.message(), responseMessage.getMessage())).responseModel(responseModel).build());
            }
        }
    }

    private String overrideTypeName(SwaggerGlobalSettings swaggerGlobalSettings, ApiResponse apiResponse) {
        if (apiResponse.response() != null) {
            return ResolvedTypes.typeName((ResolvedType)swaggerGlobalSettings.getTypeResolver().resolve((Type)apiResponse.response(), new Type[0]));
        }
        return "";
    }

    private String coalese(String overrideMessage, String defaultMessage) {
        if (Strings.isNullOrEmpty((String)overrideMessage)) {
            return defaultMessage;
        }
        return overrideMessage;
    }

    private Function<? super ResponseMessage, Integer> byStatusCode() {
        return new Function<ResponseMessage, Integer>(){

            public Integer apply(ResponseMessage input) {
                return input.getCode();
            }
        };
    }

    private List<ResponseMessage> globalResponseMessages(SwaggerGlobalSettings swaggerGlobalSettings, RequestMethod currentHttpMethod) {
        ArrayList responseMessages = Lists.newArrayList();
        Map<RequestMethod, List<ResponseMessage>> globalResponseMessages = swaggerGlobalSettings.getGlobalResponseMessages();
        if (null != globalResponseMessages) {
            responseMessages.addAll((Collection)Optional.fromNullable(globalResponseMessages.get(currentHttpMethod)).or(new ArrayList()));
        }
        return responseMessages;
    }
}

