/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.core;

import com.google.common.collect.Maps;
import com.mangofactory.swagger.models.dto.ApiListing;
import com.mangofactory.swagger.models.dto.ResourceListing;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class SwaggerCache {
    private Map<String, ResourceListing> swaggerApiResourceListingMap = Maps.newLinkedHashMap();
    private Map<String, Map<String, ApiListing>> swaggerApiListingMap = Maps.newLinkedHashMap();

    public void addSwaggerResourceListing(String swaggerGroup, ResourceListing resourceListing) {
        this.swaggerApiResourceListingMap.put(swaggerGroup, resourceListing);
    }

    public void addApiListings(String swaggerGroup, Map<String, ApiListing> apiListings) {
        this.swaggerApiListingMap.put(swaggerGroup, apiListings);
    }

    public ResourceListing getResourceListing(String key) {
        return this.swaggerApiResourceListingMap.get(key);
    }

    public Map<String, ResourceListing> getSwaggerApiResourceListingMap() {
        return this.swaggerApiResourceListingMap;
    }

    public Map<String, Map<String, ApiListing>> getSwaggerApiListingMap() {
        return this.swaggerApiListingMap;
    }
}

