/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models;

import com.fasterxml.classmate.MemberResolver;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mangofactory.swagger.models.Accessors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccessorsProvider {
    private TypeResolver typeResolver;

    @Autowired
    public AccessorsProvider(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    private Predicate<ResolvedMethod> onlyGettersAndSetters() {
        return new Predicate<ResolvedMethod>(){

            public boolean apply(ResolvedMethod input) {
                return Accessors.isGetter(input.getRawMember()) || Accessors.isSetter(input.getRawMember());
            }
        };
    }

    public ImmutableList<ResolvedMethod> in(ResolvedType resolvedType) {
        MemberResolver resolver = new MemberResolver(this.typeResolver);
        resolver.setIncludeLangObject(false);
        if (resolvedType.getErasedType() == Object.class) {
            return ImmutableList.of();
        }
        ResolvedTypeWithMembers typeWithMembers = resolver.resolve(resolvedType, null, null);
        return FluentIterable.from((Iterable)Lists.newArrayList((Object[])typeWithMembers.getMemberMethods())).filter(this.onlyGettersAndSetters()).toList();
    }
}

