/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.classmate.members.ResolvedMember;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mangofactory.swagger.models.Accessors;
import com.mangofactory.swagger.models.AccessorsProvider;
import com.mangofactory.swagger.models.BeanModelProperty;
import com.mangofactory.swagger.models.FieldModelProperty;
import com.mangofactory.swagger.models.FieldsProvider;
import com.mangofactory.swagger.models.ModelPropertiesProvider;
import com.mangofactory.swagger.models.ModelProperty;
import com.mangofactory.swagger.models.alternates.AlternateTypeProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultModelPropertiesProvider
implements ModelPropertiesProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultModelPropertiesProvider.class);
    private ObjectMapper objectMapper;
    private final TypeResolver typeResolver;
    private final AlternateTypeProvider alternateTypeProvider;
    private final AccessorsProvider accessors;
    private final FieldsProvider fields;

    @Autowired
    public DefaultModelPropertiesProvider(TypeResolver typeResolver, AlternateTypeProvider alternateTypeProvider, AccessorsProvider accessors, FieldsProvider fields) {
        this.typeResolver = typeResolver;
        this.alternateTypeProvider = alternateTypeProvider;
        this.accessors = accessors;
        this.fields = fields;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public List<? extends ModelProperty> serializableProperties(ResolvedType resolvedType) {
        ArrayList serializationCandidates = Lists.newArrayList();
        SerializationConfig serializationConfig = this.objectMapper.getSerializationConfig();
        BeanDescription beanDescription = serializationConfig.introspect(TypeFactory.defaultInstance().constructType((Type)resolvedType.getErasedType()));
        ImmutableMap propertyLookup = Maps.uniqueIndex((Iterable)beanDescription.findProperties(), this.beanPropertyByInternalName());
        for (ResolvedMethod childProperty : this.accessors.in(resolvedType)) {
            if (!propertyLookup.containsKey(Accessors.propertyName(childProperty.getName()))) continue;
            BeanPropertyDefinition propertyDefinition = (BeanPropertyDefinition)propertyLookup.get(Accessors.propertyName(childProperty.getName()));
            Optional<BeanPropertyDefinition> jacksonProperty = this.jacksonPropertyWithSameInternalName(beanDescription, propertyDefinition);
            AnnotatedMember member = propertyDefinition.getPrimaryMember();
            if (!BeanModelProperty.accessorMemberIs((ResolvedMember)childProperty, this.methodName(member))) continue;
            serializationCandidates.add(this.beanModelProperty(childProperty, jacksonProperty));
        }
        return serializationCandidates;
    }

    private Optional<BeanPropertyDefinition> jacksonPropertyWithSameInternalName(BeanDescription beanDescription, BeanPropertyDefinition propertyDefinition) {
        return FluentIterable.from((Iterable)beanDescription.findProperties()).firstMatch(this.withSameInternalName(propertyDefinition));
    }

    private String methodName(AnnotatedMember member) {
        if (member == null || member.getMember() == null) {
            return "";
        }
        return member.getMember().getName();
    }

    private List<? extends ModelProperty> serializableFields(ResolvedType resolvedType) {
        ArrayList serializationCandidates = Lists.newArrayList();
        SerializationConfig serializationConfig = this.objectMapper.getSerializationConfig();
        BeanDescription beanDescription = serializationConfig.introspect(TypeFactory.defaultInstance().constructType((Type)resolvedType.getErasedType()));
        ImmutableMap propertyLookup = Maps.uniqueIndex((Iterable)beanDescription.findProperties(), this.beanPropertyByInternalName());
        for (ResolvedField resolvedField : this.fields.in(resolvedType)) {
            if (!propertyLookup.containsKey(resolvedField.getName())) continue;
            BeanPropertyDefinition propertyDefinition = (BeanPropertyDefinition)propertyLookup.get(resolvedField.getName());
            Optional<BeanPropertyDefinition> jacksonProperty = this.jacksonPropertyWithSameInternalName(beanDescription, propertyDefinition);
            AnnotatedMember member = propertyDefinition.getPrimaryMember();
            if (!this.memberIsAField(member)) continue;
            serializationCandidates.add(new FieldModelProperty(((BeanPropertyDefinition)jacksonProperty.get()).getName(), resolvedField, this.alternateTypeProvider));
        }
        return serializationCandidates;
    }

    private boolean memberIsAField(AnnotatedMember member) {
        return member != null && member.getMember() != null && Field.class.isAssignableFrom(member.getMember().getClass());
    }

    public List<? extends ModelProperty> deserializableProperties(ResolvedType resolvedType) {
        ArrayList serializationCandidates = Lists.newArrayList();
        DeserializationConfig serializationConfig = this.objectMapper.getDeserializationConfig();
        BeanDescription beanDescription = serializationConfig.introspect(TypeFactory.defaultInstance().constructType((Type)resolvedType.getErasedType()));
        ImmutableMap propertyLookup = Maps.uniqueIndex((Iterable)beanDescription.findProperties(), this.beanPropertyByInternalName());
        for (ResolvedMethod childProperty : this.accessors.in(resolvedType)) {
            if (!propertyLookup.containsKey(Accessors.propertyName(childProperty.getName()))) continue;
            BeanPropertyDefinition propertyDefinition = (BeanPropertyDefinition)propertyLookup.get(Accessors.propertyName(childProperty.getName()));
            Optional<BeanPropertyDefinition> jacksonProperty = this.jacksonPropertyWithSameInternalName(beanDescription, propertyDefinition);
            try {
                AnnotatedMember member = propertyDefinition.getPrimaryMember();
                if (!BeanModelProperty.accessorMemberIs((ResolvedMember)childProperty, this.methodName(member))) continue;
                serializationCandidates.add(this.beanModelProperty(childProperty, jacksonProperty));
            }
            catch (Exception e) {
                log.warn(e.getMessage());
            }
        }
        return serializationCandidates;
    }

    private BeanModelProperty beanModelProperty(ResolvedMethod childProperty, Optional<BeanPropertyDefinition> jacksonProperty) {
        return new BeanModelProperty(((BeanPropertyDefinition)jacksonProperty.get()).getName(), childProperty, Accessors.isGetter(childProperty.getRawMember()), this.typeResolver, this.alternateTypeProvider);
    }

    public List<? extends ModelProperty> deserializableFields(ResolvedType resolvedType) {
        ArrayList serializationCandidates = Lists.newArrayList();
        DeserializationConfig serializationConfig = this.objectMapper.getDeserializationConfig();
        BeanDescription beanDescription = serializationConfig.introspect(TypeFactory.defaultInstance().constructType((Type)resolvedType.getErasedType()));
        ImmutableMap propertyLookup = Maps.uniqueIndex((Iterable)beanDescription.findProperties(), this.beanPropertyByInternalName());
        for (ResolvedField resolvedField : this.fields.in(resolvedType)) {
            if (!propertyLookup.containsKey(resolvedField.getName())) continue;
            BeanPropertyDefinition propertyDefinition = (BeanPropertyDefinition)propertyLookup.get(resolvedField.getName());
            Optional<BeanPropertyDefinition> jacksonProperty = this.jacksonPropertyWithSameInternalName(beanDescription, propertyDefinition);
            AnnotatedMember member = propertyDefinition.getPrimaryMember();
            if (!this.memberIsAField(member)) continue;
            serializationCandidates.add(new FieldModelProperty(((BeanPropertyDefinition)jacksonProperty.get()).getName(), resolvedField, this.alternateTypeProvider));
        }
        return serializationCandidates;
    }

    private Predicate<BeanPropertyDefinition> withSameInternalName(final BeanPropertyDefinition propertyDefinition) {
        return new Predicate<BeanPropertyDefinition>(){

            public boolean apply(BeanPropertyDefinition input) {
                return input.getInternalName() == propertyDefinition.getInternalName();
            }
        };
    }

    private Function<BeanPropertyDefinition, String> beanPropertyByInternalName() {
        return new Function<BeanPropertyDefinition, String>(){

            public String apply(BeanPropertyDefinition input) {
                return input.getInternalName();
            }
        };
    }

    @Override
    public Iterable<? extends ModelProperty> propertiesForSerialization(ResolvedType type) {
        ArrayList modelProperties = Lists.newArrayList(this.serializableFields(type));
        modelProperties.addAll(this.serializableProperties(type));
        return modelProperties;
    }

    @Override
    public Iterable<? extends ModelProperty> propertiesForDeserialization(ResolvedType type) {
        ArrayList modelProperties = Lists.newArrayList(this.deserializableFields(type));
        modelProperties.addAll(this.deserializableProperties(type));
        return modelProperties;
    }
}

