/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.members.ResolvedField;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.mangofactory.swagger.models.ModelContext;
import com.mangofactory.swagger.models.ModelProperty;
import com.mangofactory.swagger.models.ResolvedTypes;
import com.mangofactory.swagger.models.alternates.AlternateTypeProvider;
import com.wordnik.swagger.annotations.ApiModelProperty;
import com.wordnik.swagger.model.AllowableValues;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import scala.Option;

public class FieldModelProperty
implements ModelProperty {
    private final String name;
    private final ResolvedField childField;
    private final AlternateTypeProvider alternateTypeProvider;

    public FieldModelProperty(String name, ResolvedField childField, AlternateTypeProvider alternateTypeProvider) {
        this.name = name;
        this.childField = childField;
        this.alternateTypeProvider = alternateTypeProvider;
    }

    private ResolvedType realType(ResolvedField field) {
        return field.getType();
    }

    @Override
    public String typeName(ModelContext modelContext) {
        return ResolvedTypes.typeName(this.getType());
    }

    @Override
    public String qualifiedTypeName() {
        ResolvedType resolvedType = this.getType();
        if (resolvedType.getTypeParameters().size() > 0) {
            return resolvedType.toString();
        }
        return ResolvedTypes.simpleQualifiedTypeName(resolvedType);
    }

    @Override
    public AllowableValues allowableValues() {
        return ResolvedTypes.allowableValues(this.getType());
    }

    @Override
    public Option<String> propertyDescription() {
        Optional<ApiModelProperty> modelPropertyAnnotation = this.modelPropertyAnnotation(this.childField.getRawMember());
        if (modelPropertyAnnotation.isPresent()) {
            ApiModelProperty annotation = (ApiModelProperty)modelPropertyAnnotation.get();
            if (!Strings.isNullOrEmpty((String)annotation.value())) {
                return Option.apply((Object)annotation.value());
            }
            if (!Strings.isNullOrEmpty((String)annotation.notes())) {
                return Option.apply((Object)annotation.notes());
            }
        }
        return Option.apply(null);
    }

    @Override
    public boolean isRequired() {
        Optional<ApiModelProperty> modelPropertyAnnotation = this.modelPropertyAnnotation(this.childField.getRawMember());
        return modelPropertyAnnotation.isPresent() && ((ApiModelProperty)modelPropertyAnnotation.get()).required();
    }

    private Optional<ApiModelProperty> modelPropertyAnnotation(AnnotatedElement annotated) {
        for (Annotation annotation : annotated.getDeclaredAnnotations()) {
            if (!(annotation instanceof ApiModelProperty)) continue;
            return Optional.of((Object)((ApiModelProperty)annotation));
        }
        return Optional.absent();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ResolvedType getType() {
        return this.alternateTypeProvider.alternateFor(this.realType(this.childField));
    }
}

