/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.ResolvedMember;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.google.common.base.Strings;
import com.mangofactory.swagger.models.ModelContext;
import com.mangofactory.swagger.models.ModelProperty;
import com.mangofactory.swagger.models.ResolvedTypes;
import com.mangofactory.swagger.models.alternates.AlternateTypeProvider;
import com.wordnik.swagger.annotations.ApiModelProperty;
import com.wordnik.swagger.model.AllowableValues;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.springframework.core.annotation.AnnotationUtils;
import scala.Option;

public class BeanModelProperty
implements ModelProperty {
    private String name;
    private final ResolvedMethod method;
    private final boolean isGetter;
    private TypeResolver typeResolver;
    private final AlternateTypeProvider alternateTypeProvider;

    public BeanModelProperty(String propertyName, ResolvedMethod method, boolean isGetter, TypeResolver typeResolver, AlternateTypeProvider alternateTypeProvider) {
        this.name = propertyName;
        this.method = method;
        this.isGetter = isGetter;
        this.typeResolver = typeResolver;
        this.alternateTypeProvider = alternateTypeProvider;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String alias) {
        this.name = alias;
    }

    @Override
    public ResolvedType getType() {
        return this.alternateTypeProvider.alternateFor(this.realType());
    }

    private ResolvedType realType() {
        if (this.isGetter) {
            if (this.method.getReturnType().getErasedType().getTypeParameters().length > 0) {
                return this.method.getReturnType();
            }
            return this.typeResolver.resolve((Type)this.method.getReturnType().getErasedType(), new Type[0]);
        }
        if (this.method.getArgumentType(0).getErasedType().getTypeParameters().length > 0) {
            return this.method.getArgumentType(0);
        }
        return this.typeResolver.resolve((Type)this.method.getArgumentType(0).getErasedType(), new Type[0]);
    }

    @Override
    public String typeName(ModelContext modelContext) {
        return ResolvedTypes.typeName(this.getType());
    }

    @Override
    public String qualifiedTypeName() {
        if (this.getType().getTypeParameters().size() > 0) {
            return this.getType().toString();
        }
        return ResolvedTypes.simpleQualifiedTypeName(this.getType());
    }

    @Override
    public AllowableValues allowableValues() {
        return ResolvedTypes.allowableValues(this.getType());
    }

    @Override
    public Option<String> propertyDescription() {
        ApiModelProperty annotation = (ApiModelProperty)AnnotationUtils.findAnnotation((Method)this.method.getRawMember(), ApiModelProperty.class);
        if (annotation != null) {
            if (!Strings.isNullOrEmpty((String)annotation.value())) {
                return Option.apply((Object)annotation.value());
            }
            if (!Strings.isNullOrEmpty((String)annotation.notes())) {
                return Option.apply((Object)annotation.notes());
            }
        }
        return Option.apply(null);
    }

    @Override
    public boolean isRequired() {
        ApiModelProperty annotation = (ApiModelProperty)AnnotationUtils.findAnnotation((Method)this.method.getRawMember(), ApiModelProperty.class);
        if (annotation != null) {
            return annotation.required();
        }
        return false;
    }

    public static boolean accessorMemberIs(ResolvedMember method, String methodName) {
        return method.getRawMember().getName().equals(methodName);
    }
}

