/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models.property;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.wordnik.swagger.annotations.ApiModelProperty;
import com.wordnik.swagger.model.AllowableListValues;
import java.util.Collection;
import java.util.List;
import scala.collection.JavaConversions;

public final class ApiModelProperties {
    private ApiModelProperties() {
        throw new UnsupportedOperationException();
    }

    public static Function<ApiModelProperty, AllowableListValues> toAllowableList() {
        return new Function<ApiModelProperty, AllowableListValues>(){

            public AllowableListValues apply(ApiModelProperty annotation) {
                List allowableValues = Splitter.on((char)',').omitEmptyStrings().splitToList((CharSequence)Strings.nullToEmpty((String)annotation.allowableValues()));
                return new AllowableListValues(JavaConversions.collectionAsScalaIterable((Collection)allowableValues).toList(), "LIST");
            }
        };
    }

    public static Function<ApiModelProperty, Boolean> toIsRequired() {
        return new Function<ApiModelProperty, Boolean>(){

            public Boolean apply(ApiModelProperty annotation) {
                return annotation.required();
            }
        };
    }

    public static Function<ApiModelProperty, String> toDescription() {
        return new Function<ApiModelProperty, String>(){

            public String apply(ApiModelProperty annotation) {
                String description = "";
                if (!Strings.isNullOrEmpty((String)annotation.value())) {
                    description = annotation.value();
                } else if (!Strings.isNullOrEmpty((String)annotation.notes())) {
                    description = annotation.notes();
                }
                return description;
            }
        };
    }
}

