package com.mangopay.core.enumerations;

/**
 * Currency ISO 4217 symbols enumeration.
 */
public enum CurrencyIso {
    /**
    * Not specified.
    */ 
    NotSpecified,

    /**
    * No currency
    */ 
    XXX,
    /**
    * United Arab Emirates dirham
    */ 
    AED,
    /**
    * Afghan afghani
    */ 
    AFN,
    /**
    * Albanian lek
    */ 
    ALL,
    /**
    * Armenian dram
    */ 
    AMD,
    /**
    * Netherlands Antillean guilder
    */ 
    ANG,
    /**
    * Angolan kwanza
    */ 
    AOA,
    /**
    * Argentine peso
    */ 
    ARS,
    /**
    * Australian dollar
    */ 
    AUD,
    /**
    * Aruban florin
    */ 
    AWG,
    /**
    * Azerbaijani manat
    */ 
    AZN,
    /**
    * Bosnia and Herzegovina convertible mark
    */ 
    BAM,
    /**
    * Barbados dollar
    */ 
    BBD,
    /**
    * Bangladeshi taka
    */ 
    BDT,
    /**
    * Bulgarian lev
    */ 
    BGN,
    /**
    * Bahraini dinar
    */ 
    BHD,
    /**
    * Burundian franc
    */ 
    BIF,
    /**
    * Bermudian dollar
    */ 
    BMD,
    /**
    * Brunei dollar
    */ 
    BND,
    /**
    * Boliviano
    */ 
    BOB,
    /**
    * Bolivian Mvdol (funds code)
    */ 
    BOV,
    /**
    * Brazilian real
    */ 
    BRL,
    /**
    * Bahamian dollar
    */ 
    BSD,
    /**
    * Bhutanese ngultrum
    */ 
    BTN,
    /**
    * Botswana pula
    */ 
    BWP,
    /**
    * Belarusian ruble
    */ 
    BYR,
    /**
    * Belize dollar
    */ 
    BZD,
    /**
    * Canadian dollar
    */ 
    CAD,
    /**
    * Congolese franc
    */ 
    CDF,
    /**
    * WIR Euro (complementary currency)
    */ 
    CHE,
    /**
    * Swiss franc
    */ 
    CHF,
    /**
    * WIR Franc (complementary currency)
    */ 
    CHW,
    /**
    * Unidad de Fomento (funds code)
    */ 
    CLF,
    /**
    * Chilean peso
    */ 
    CLP,
    /**
    * Chinese yuan
    */ 
    CNY,
    /**
    * Colombian peso
    */ 
    COP,
    /**
    * Unidad de Valor Real (UVR) (funds code)[7]
    */ 
    COU,
    /**
    * Costa Rican colon
    */ 
    CRC,
    /**
    * Cuban convertible peso
    */ 
    CUC,
    /**
    * Cuban peso
    */ 
    CUP,
    /**
    * Cape Verde escudo
    */ 
    CVE,
    /**
    * Czech koruna
    */ 
    CZK,
    /**
    * Djiboutian franc
    */ 
    DJF,
    /**
    * Danish krone
    */ 
    DKK,
    /**
    * Dominican peso
    */ 
    DOP,
    /**
    * Algerian dinar
    */ 
    DZD,
    /**
    * Egyptian pound
    */ 
    EGP,
    /**
    * Eritrean nakfa
    */ 
    ERN,
    /**
    * Ethiopian birr
    */ 
    ETB,
    /**
    * Euro
    */ 
    EUR,
    /**
    * Fiji dollar
    */ 
    FJD,
    /**
    * Falkland Islands pound
    */ 
    FKP,
    /**
    * Pound sterling
    */ 
    GBP,
    /**
    * Georgian lari
    */ 
    GEL,
    /**
    * Ghanaian cedi
    */ 
    GHS,
    /**
    * Gibraltar pound
    */ 
    GIP,
    /**
    * Gambian dalasi
    */ 
    GMD,
    /**
    * Guinean franc
    */ 
    GNF,
    /**
    * Guatemalan quetzal
    */ 
    GTQ,
    /**
    * Guyanese dollar
    */ 
    GYD,
    /**
    * Hong Kong dollar
    */ 
    HKD,
    /**
    * Honduran lempira
    */ 
    HNL,
    /**
    * Croatian kuna
    */ 
    HRK,
    /**
    * Haitian gourde
    */ 
    HTG,
    /**
    * Hungarian forint
    */ 
    HUF,
    /**
    * Indonesian rupiah
    */ 
    IDR,
    /**
    * Israeli new shekel
    */ 
    ILS,
    /**
    * Indian rupee
    */ 
    INR,
    /**
    * Iraqi dinar
    */ 
    IQD,
    /**
    * Iranian rial
    */ 
    IRR,
    /**
    * Icelandic króna
    */ 
    ISK,
    /**
    * Jamaican dollar
    */ 
    JMD,
    /**
    * Jordanian dinar
    */ 
    JOD,
    /**
    * Japanese yen
    */ 
    JPY,
    /**
    * Kenyan shilling
    */ 
    KES,
    /**
    * Kyrgyzstani som
    */ 
    KGS,
    /**
    * Cambodian riel
    */ 
    KHR,
    /**
    * Comoro franc
    */ 
    KMF,
    /**
    * North Korean won
    */ 
    KPW,
    /**
    * South Korean won
    */ 
    KRW,
    /**
    * Kuwaiti dinar
    */ 
    KWD,
    /**
    * Cayman Islands dollar
    */ 
    KYD,
    /**
    * Kazakhstani tenge
    */ 
    KZT,
    /**
    * Lao kip
    */ 
    LAK,
    /**
    * Lebanese pound
    */ 
    LBP,
    /**
    * Sri Lankan rupee
    */ 
    LKR,
    /**
    * Liberian dollar
    */ 
    LRD,
    /**
    * Lesotho loti
    */ 
    LSL,
    /**
    * Lithuanian litas
    */ 
    LTL,
    /**
    * Libyan dinar
    */ 
    LYD,
    /**
    * Moroccan dirham
    */ 
    MAD,
    /**
    * Moldovan leu
    */ 
    MDL,
    /**
    * Malagasy ariary
    */ 
    MGA,
    /**
    * Macedonian denar
    */ 
    MKD,
    /**
    * Myanmar kyat
    */ 
    MMK,
    /**
    * Mongolian tugrik
    */ 
    MNT,
    /**
    * Macanese pataca
    */ 
    MOP,
    /**
    * Mauritanian ouguiya
    */ 
    MRO,
    /**
    * Mauritian rupee
    */ 
    MUR,
    /**
    * Maldivian rufiyaa
    */ 
    MVR,
    /**
    * Malawian kwacha
    */ 
    MWK,
    /**
    * Mexican peso
    */ 
    MXN,
    /**
    * Mexican Unidad de Inversion(UDI) (funds code)
    */ 
    MXV,
    /**
    * Malaysian ringgit
    */ 
    MYR,
    /**
    * Mozambican metical
    */ 
    MZN,
    /**
    * Namibian dollar
    */ 
    NAD,
    /**
    * Nigerian naira
    */ 
    NGN,
    /**
    * Nicaraguan córdoba
    */ 
    NIO,
    /**
    * Norwegian krone
    */ 
    NOK,
    /**
    * Nepalese rupee
    */ 
    NPR,
    /**
    * New Zealand dollar
    */ 
    NZD,
    /**
    * Omani rial
    */ 
    OMR,
    /**
    * Panamanian balboa
    */ 
    PAB,
    /**
    * Peruvian nuevo sol
    */ 
    PEN,
    /**
    * Papua New Guinean kina
    */ 
    PGK,
    /**
    * Philippine peso
    */ 
    PHP,
    /**
    * Pakistani rupee
    */ 
    PKR,
    /**
    * Polish złoty
    */ 
    PLN,
    /**
    * Paraguayan guaraní
    */ 
    PYG,
    /**
    * Qatari riyal
    */ 
    QAR,
    /**
    * Romanian new leu
    */ 
    RON,
    /**
    * Serbian dinar
    */ 
    RSD,
    /**
    * Russian ruble
    */ 
    RUB,
    /**
    * Rwandan franc
    */ 
    RWF,
    /**
    * Saudi riyal
    */ 
    SAR,
    /**
    * Solomon Islands dollar
    */ 
    SBD,
    /**
    * Seychelles rupee
    */ 
    SCR,
    /**
    * Sudanese pound
    */ 
    SDG,
    /**
    * Swedish krona/kronor
    */ 
    SEK,
    /**
    * Singapore dollar
    */ 
    SGD,
    /**
    * Saint Helena pound
    */ 
    SHP,
    /**
    * Sierra Leonean leone
    */ 
    SLL,
    /**
    * Somali shilling
    */ 
    SOS,
    /**
    * Surinamese dollar
    */ 
    SRD,
    /**
    * South Sudanese pound
    */ 
    SSP,
    /**
    * Sao Tomé and Príncipe dobra
    */ 
    STD,
    /**
    * Syrian pound
    */ 
    SYP,
    /**
    * Swazi lilangeni
    */ 
    SZL,
    /**
    * Thai baht
    */ 
    THB,
    /**
    * Tajikistani somoni
    */ 
    TJS,
    /**
    * Turkmenistani manat
    */ 
    TMT,
    /**
    * Tunisian dinar
    */ 
    TND,
    /**
    * Tongan pa'anga
    */ 
    TOP,
    /**
    * Turkish lira
    */ 
    TRY,
    /**
    * Trinidad and Tobago dollar
    */ 
    TTD,
    /**
    * New Taiwan dollar
    */ 
    TWD,
    /**
    * Tanzanian shilling
    */ 
    TZS,
    /**
    * Ukrainian hryvnia
    */ 
    UAH,
    /**
    * Ugandan shilling
    */ 
    UGX,
    /**
    * United States dollar
    */ 
    USD,
    /**
    * United States dollar (next day) (funds code)
    */ 
    USN,
    /**
    * United States dollar (same day) (funds code)[10]
    */ 
    USS,
    /**
    * Uruguay Peso en Unidades Indexadas (URUIURUI) (funds code)
    */ 
    UYI,
    /**
    * Uruguayan peso
    */ 
    UYU,
    /**
    * Uzbekistan som
    */ 
    UZS,
    /**
    * Venezuelan bolívar
    */ 
    VEF,
    /**
    * Vietnamese dong
    */ 
    VND,
    /**
    * Vanuatu vatu
    */ 
    VUV,
    /**
    * Samoan tala
    */ 
    WST,
    /**
    * CFA franc BEAC
    */ 
    XAF,
    /**
    * Silver (one troy ounce)
    */ 
    XAG,
    /**
    * Gold (one troy ounce)
    */ 
    XAU,
    /**
    * European Composite Unit(EURCO) (bond market unit)
    */ 
    XBA,
    /**
    * European Monetary Unit(E.M.U.-6) (bond market unit)
    */ 
    XBB,
    /**
    * European Unit of Account 9(E.U.A.-9) (bond market unit)
    */ 
    XBC,
    /**
    * European Unit of Account 17(E.U.A.-17) (bond market unit)
    */ 
    XBD,
    /**
    * bitcoinInternational internet currency
    */ 
    XBT,
    /**
    * East Caribbean dollar
    */ 
    XCD,
    /**
    * Special drawing rights
    */ 
    XDR,
    /**
    * UIC franc(special settlement currency)
    */ 
    XFU,
    /**
    * CFA franc BCEAO
    */ 
    XOF,
    /**
    * Palladium (onetroy ounce)
    */ 
    XPD,
    /**
    * CFP franc(franc Pacifique)
    */ 
    XPF,
    /**
    * Platinum (onetroy ounce)
    */ 
    XPT,
    /**
    * SUCRE
    */ 
    XSU,
    /**
    * Code reserved for testing purposes
    */ 
    XTS,
    /**
    * ADB Unit of Account
    */ 
    XUA,
    /**
    * Yemeni rial
    */ 
    YER,
    /**
    * South African rand
    */ 
    ZAR,
    /**
    * Zambian kwacha
    */ 
    ZMW,
    /**
    * Zimbabwe dollar
    */ 
    ZWD
}
