package com.mangopay.entities;

import com.google.gson.annotations.SerializedName;
import com.mangopay.core.EntityBase;
import com.mangopay.core.enumerations.KycDocumentType;
import com.mangopay.core.enumerations.KycStatus;

import java.util.ArrayList;

/**
 * KYC document entity.
 */
public class KycDocument extends EntityBase {

    /**
     * Type of KYC document.
     */
    @SerializedName("Type")
    private KycDocumentType type;

    /**
     * Status of KYC document.
     */
    @SerializedName("Status")
    private KycStatus status;

    /**
     * Refused reason type.
     */
    @SerializedName("RefusedReasonType")
    private String refusedReasonType;

    /**
     * Refused reason message.
     */
    @SerializedName("RefusedReasonMessage")
    private String refusedReasonMessage;

    /**
     * User identifier.
     */
    @SerializedName("UserId")
    private String userId;

    /**
     * Date when this document was processed (UNIX timestamp).
     */
    @SerializedName("ProcessedDate")
    private Long processedDate;

    /**
     * More information regarding why the document has been rejected.
     */
    @SerializedName("Flags")
    private ArrayList<String> flags;

    public KycDocumentType getType() {
        return type;
    }

    public void setType(KycDocumentType type) {
        this.type = type;
    }

    public KycStatus getStatus() {
        return status;
    }

    public void setStatus(KycStatus status) {
        this.status = status;
    }

    public String getRefusedReasonType() {
        return refusedReasonType;
    }

    public void setRefusedReasonType(String refusedReasonType) {
        this.refusedReasonType = refusedReasonType;
    }

    public String getRefusedReasonMessage() {
        return refusedReasonMessage;
    }

    public void setRefusedReasonMessage(String refusedReasonMessage) {
        this.refusedReasonMessage = refusedReasonMessage;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Long getProcessedDate() {
        return processedDate;
    }

    public ArrayList<String> getFlags() {
        return flags;
    }

    public void setFlags(ArrayList<String> flags) {
        this.flags = flags;
    }
}
