/*
 * Decompiled with CFR 0.152.
 */
package com.mangopay.core.APIs.implementation;

import com.google.gson.GsonBuilder;
import com.mangopay.MangoPayApi;
import com.mangopay.core.APIs.ApiBase;
import com.mangopay.core.APIs.IdempotencyApi;
import com.mangopay.core.deserializer.PayOutDeserializer;
import com.mangopay.core.serializer.PayOutSerializer;
import com.mangopay.entities.BankAccount;
import com.mangopay.entities.BankingAlias;
import com.mangopay.entities.CardPreAuthorization;
import com.mangopay.entities.CardRegistration;
import com.mangopay.entities.DisputeDocument;
import com.mangopay.entities.Hook;
import com.mangopay.entities.IdempotencyResponse;
import com.mangopay.entities.KycDocument;
import com.mangopay.entities.Mandate;
import com.mangopay.entities.PayIn;
import com.mangopay.entities.PayOut;
import com.mangopay.entities.Refund;
import com.mangopay.entities.SettlementTransfer;
import com.mangopay.entities.Transfer;
import com.mangopay.entities.UserLegal;
import com.mangopay.entities.UserNatural;
import com.mangopay.entities.Wallet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IdempotencyApiImpl
extends ApiBase
implements IdempotencyApi {
    public IdempotencyApiImpl(MangoPayApi root, GsonBuilder gsonBuilder) {
        super(root);
        gsonBuilder.registerTypeAdapter(PayOut.class, (Object)new PayOutSerializer());
        gsonBuilder.registerTypeAdapter(PayOut.class, (Object)new PayOutDeserializer());
    }

    @Override
    public IdempotencyResponse get(String idempotencyKey) throws Exception {
        IdempotencyResponse response = this.getObject(IdempotencyResponse.class, "idempotency_response_get", idempotencyKey);
        this.instantiateResourceObject(response);
        return response;
    }

    private void instantiateResourceObject(IdempotencyResponse response) throws Exception {
        Class<?> targetType = null;
        Map<String, Class<?>> map = this.getMapForResource();
        for (Map.Entry<String, Class<?>> entry : map.entrySet()) {
            String sourceUrl = super.getRequestUrl(entry.getKey());
            sourceUrl = String.format(sourceUrl, "[0-9a-zA-Z]+", "[0-9a-zA-Z]+");
            Pattern ex = Pattern.compile(sourceUrl = sourceUrl.replace("/", "\\/"));
            Matcher matcher = ex.matcher(response.getRequestUrl());
            if (!matcher.find()) continue;
            targetType = entry.getValue();
            break;
        }
        if (targetType == null) {
            return;
        }
        response.setResource(this.root.getGson().fromJson(this.root.getGson().toJson(response.getResource()), targetType));
    }

    private Map<String, Class<?>> getMapForResource() {
        return new HashMap<String, Class<?>>(){
            {
                this.put("preauthorization_create", CardPreAuthorization.class);
                this.put("hooks_create", Hook.class);
                this.put("cardregistration_create", CardRegistration.class);
                this.put("payins_card-web_create", PayIn.class);
                this.put("payins_card-direct_create", PayIn.class);
                this.put("payins_createrefunds", Refund.class);
                this.put("payins_preauthorized-direct_create", PayIn.class);
                this.put("payins_bankwire-direct_create", PayIn.class);
                this.put("payins_directdebit-web_create", PayIn.class);
                this.put("payins_directdebit-direct_create", PayIn.class);
                this.put("payouts_bankwire_create", PayOut.class);
                this.put("payouts_bankwire_get", PayOut.class);
                this.put("transfers_createrefunds", Refund.class);
                this.put("transfers_create", Transfer.class);
                this.put("users_createnaturals", UserNatural.class);
                this.put("users_createlegals", UserLegal.class);
                this.put("users_createkycdocument", KycDocument.class);
                this.put("users_createbankaccounts_iban", BankAccount.class);
                this.put("users_createbankaccounts_gb", BankAccount.class);
                this.put("users_createbankaccounts_us", BankAccount.class);
                this.put("users_createbankaccounts_ca", BankAccount.class);
                this.put("users_createbankaccounts_other", BankAccount.class);
                this.put("wallets_create", Wallet.class);
                this.put("disputes_document_create", DisputeDocument.class);
                this.put("disputes_repudiation_create_settlement", SettlementTransfer.class);
                this.put("mandate_create", Mandate.class);
                this.put("client_create_bankwire_direct", PayIn.class);
                this.put("banking_alias_create_iban", BankingAlias.class);
            }
        };
    }
}

