/*
 * Decompiled with CFR 0.152.
 */
package com.mangopay.core;

import com.mangopay.MangoPayApi;
import com.mangopay.core.Base64Encoder;
import com.mangopay.core.OAuthToken;
import java.util.HashMap;
import java.util.Map;

public class AuthenticationHelper {
    private MangoPayApi root;

    public AuthenticationHelper(MangoPayApi root) throws Exception {
        this.root = root;
    }

    public Map<String, String> getHttpHeaderKey() throws Exception {
        return this.getHttpHeaderStrong();
    }

    public String getHttpHeaderBasicKey() throws Exception {
        if (this.root.getConfig().getClientId() == null || this.root.getConfig().getClientId().length() == 0) {
            throw new Exception("MangoPay.config.ClientId is not set.");
        }
        if (this.root.getConfig().getClientPassword() == null || this.root.getConfig().getClientPassword().length() == 0) {
            throw new Exception("MangoPay.config.ClientPassword is not set.");
        }
        String signature = this.root.getConfig().getClientId() + ':' + this.root.getConfig().getClientPassword();
        return Base64Encoder.encode(signature);
    }

    private Map<String, String> getHttpHeaderBasic() throws Exception {
        return new HashMap<String, String>(){
            {
                this.put("Authorization", "Basic " + AuthenticationHelper.this.getHttpHeaderBasicKey());
            }
        };
    }

    private Map<String, String> getHttpHeaderStrong() throws Exception {
        final OAuthToken token = this.root.getOAuthTokenManager().getToken();
        if (token == null || token.getAccessToken().length() == 0 || token.getTokenType().length() == 0) {
            throw new Exception("OAuth token is not created (or is invalid) for strong authentication");
        }
        return new HashMap<String, String>(){
            {
                this.put("Authorization", token.getTokenType() + " " + token.getAccessToken());
            }
        };
    }
}

