/*
 * Decompiled with CFR 0.152.
 */
package com.mangopay.core;

import com.mangopay.MangoPayApi;
import com.mangopay.core.APIs.ApiBase;
import com.mangopay.core.DefaultStorageStrategy;
import com.mangopay.core.OAuthToken;
import com.mangopay.core.interfaces.StorageStrategy;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class AuthorizationTokenManager
extends ApiBase {
    private StorageStrategy storageStrategy;

    public AuthorizationTokenManager(MangoPayApi root) {
        super(root);
        this.registerCustomStorageStrategy(new DefaultStorageStrategy());
    }

    public OAuthToken getToken() throws Exception {
        OAuthToken token = this.storageStrategy.get(this.getEnvKey());
        if (token == null || token.IsExpired().booleanValue()) {
            this.storeToken(this.root.getAuthenticationManager().createToken());
        }
        return this.storageStrategy.get(this.getEnvKey());
    }

    public void storeToken(OAuthToken token) {
        this.storageStrategy.store(token, this.getEnvKey());
    }

    public void registerCustomStorageStrategy(StorageStrategy customStorageStrategy) {
        this.storageStrategy = customStorageStrategy;
    }

    private String getEnvKey() {
        String input = this.root.getConfig().getBaseUrl() + this.root.getConfig().getClientId() + this.root.getConfig().getClientPassword();
        String md5 = "";
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.update(input.getBytes(), 0, input.length());
            md5 = new BigInteger(1, m.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return md5;
    }
}

