/*
 * Decompiled with CFR 0.152.
 */
package com.mangopay.core;

import com.mangopay.core.OAuthToken;
import com.mangopay.core.interfaces.StorageStrategy;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileStorageStrategy
implements StorageStrategy {
    private String tempDir = null;

    public FileStorageStrategy(String tempDir) {
        this.tempDir = tempDir;
    }

    @Override
    public OAuthToken get(String envKey) {
        try {
            FileInputStream fileIn = new FileInputStream(this.getFilePath(envKey));
            ObjectInputStream in = new ObjectInputStream(fileIn);
            OAuthToken token = (OAuthToken)in.readObject();
            in.close();
            fileIn.close();
            return token;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public void store(OAuthToken token, String envKey) {
        try {
            FileOutputStream fileOut = new FileOutputStream(this.getFilePath(envKey));
            ObjectOutputStream out = new ObjectOutputStream(fileOut);
            out.writeObject(token);
            out.close();
            fileOut.close();
        }
        catch (Exception ex) {
            Logger.getLogger(FileStorageStrategy.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private String getFilePath(String envKey) {
        return this.tempDir + this.getClass().getName() + envKey + ".tmp";
    }
}

