/*
 * Decompiled with CFR 0.152.
 */
package com.mangopay.core;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mangopay.MangoPayApi;
import com.mangopay.core.AuthenticationHelper;
import com.mangopay.core.Dto;
import com.mangopay.core.Pagination;
import com.mangopay.core.ResponseException;
import com.mangopay.core.UrlTool;
import com.mangopay.core.enumerations.RequestType;
import com.mangopay.entities.RateLimit;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestTool {
    private MangoPayApi root;
    private boolean debugMode;
    private boolean authRequired;
    private boolean clientIdRequired;
    private Map<String, String> requestHttpHeaders;
    private HttpURLConnection connection;
    private String requestType;
    private Map<String, String> requestData;
    private int responseCode;
    private Pagination pagination;
    private Logger logger;

    public RestTool(MangoPayApi root, Boolean authRequired, Boolean clientIdRequired) {
        this.root = root;
        this.authRequired = authRequired;
        this.clientIdRequired = clientIdRequired;
        this.debugMode = this.root.getConfig().isDebugMode();
        this.logger = LoggerFactory.getLogger(RestTool.class);
    }

    public void addRequestHttpHeader(Map<String, String> httpHeader) {
        if (this.requestHttpHeaders == null) {
            this.requestHttpHeaders = new HashMap<String, String>();
        }
        this.requestHttpHeaders.putAll(httpHeader);
    }

    public void addRequestHttpHeader(String key, String value) {
        this.addRequestHttpHeader(Collections.singletonMap(key, value));
    }

    public <T extends Dto, U extends Dto> T request(Class<T> classOfT, String urlMethod, String requestType, Map<String, String> requestData, Pagination pagination, U entity) throws Exception {
        return this.request(classOfT, null, urlMethod, requestType, requestData, pagination, entity);
    }

    public <T extends Dto, U extends Dto> T request(Class<T> classOfT, String idempotencyKey, String urlMethod, String requestType, Map<String, String> requestData, Pagination pagination, U entity) throws Exception {
        this.requestType = requestType;
        this.requestData = requestData;
        return this.doRequest(classOfT, idempotencyKey, urlMethod, pagination, entity);
    }

    public <T extends Dto> T request(Class<T> classOfT, String idempotencyKey, String urlMethod, String requestType) throws Exception {
        return this.request(classOfT, idempotencyKey, urlMethod, requestType, null, null, null);
    }

    public <T extends Dto> T request(Class<T> classOfT, String idempotencyKey, String urlMethod, String requestType, Map<String, String> requestData) throws Exception {
        return this.request(classOfT, idempotencyKey, urlMethod, requestType, requestData, null, null);
    }

    public <T extends Dto> T request(Class<T> classOfT, String idempotencyKey, String urlMethod, String requestType, Map<String, String> requestData, Pagination pagination) throws Exception {
        return this.request(classOfT, idempotencyKey, urlMethod, requestType, requestData, pagination, null);
    }

    public <T extends Dto> List<T> requestList(Class<T[]> classOfT, Class<T> classOfTItem, String urlMethod, String requestType, Map<String, String> requestData, Pagination pagination, Map<String, String> additionalUrlParams) throws Exception {
        this.requestType = requestType;
        this.requestData = requestData;
        return this.doRequestList(classOfT, classOfTItem, urlMethod, pagination, additionalUrlParams);
    }

    public <T extends Dto> List<T> requestList(Class<T[]> classOfT, Class<T> classOfTItem, String urlMethod, String requestType) throws Exception {
        return this.requestList(classOfT, classOfTItem, urlMethod, requestType, null, null, null);
    }

    public <T extends Dto> List<T> requestList(Class<T[]> classOfT, Class<T> classOfTItem, String urlMethod, String requestType, Map<String, String> requestData) throws Exception {
        return this.requestList(classOfT, classOfTItem, urlMethod, requestType, requestData, null, null);
    }

    public <T extends Dto> List<T> requestList(Class<T[]> classOfT, Class<T> classOfTItem, String urlMethod, String requestType, Map<String, String> requestData, Pagination pagination) throws Exception {
        return this.requestList(classOfT, classOfTItem, urlMethod, requestType, requestData, pagination, null);
    }

    private <T extends Dto, U extends Dto> T doRequest(Class<T> classOfT, String idempotencyKey, String urlMethod, Pagination pagination, U entity) throws Exception {
        Dto response = null;
        try {
            StringBuffer resp;
            UrlTool urlTool = new UrlTool(this.root);
            String restUrl = urlTool.getRestUrl(urlMethod, this.clientIdRequired, pagination, null);
            URL url = new URL(urlTool.getFullUrl(restUrl));
            if (this.debugMode) {
                this.logger.info("FullUrl: {}", (Object)urlTool.getFullUrl(restUrl));
            }
            this.connection = (HttpURLConnection)url.openConnection();
            if (this.connection instanceof HttpsURLConnection) {
                this.configureSslContext((HttpsURLConnection)this.connection);
            }
            this.connection.setConnectTimeout(this.root.getConfig().getConnectTimeout());
            this.connection.setReadTimeout(this.root.getConfig().getReadTimeout());
            this.connection.setRequestMethod(this.requestType);
            Map<String, String> httpHeaders = this.getHttpHeaders(restUrl);
            for (Map.Entry<String, String> entry : httpHeaders.entrySet()) {
                this.connection.addRequestProperty(entry.getKey(), entry.getValue());
                if (!this.debugMode) continue;
                this.logger.info("HTTP Header: {}", (Object)(entry.getKey() + ": " + entry.getValue()));
            }
            if (idempotencyKey != null && !idempotencyKey.trim().isEmpty()) {
                this.connection.addRequestProperty("Idempotency-Key", idempotencyKey);
            }
            this.connection.setUseCaches(false);
            this.connection.setDoInput(true);
            this.connection.setDoOutput(true);
            if (pagination != null) {
                this.pagination = pagination;
            }
            if (this.debugMode) {
                this.logger.info("RequestType: {}", (Object)this.requestType);
            }
            if (this.requestData != null || entity != null || this.requestType.equals(RequestType.POST.toString())) {
                String requestBody = "";
                if (entity != null) {
                    requestBody = this.root.getGson().toJson(entity);
                }
                if (this.requestData != null) {
                    String params = "";
                    for (Map.Entry<String, String> entry : this.requestData.entrySet()) {
                        params = params + String.format("&%s=%s", URLEncoder.encode(entry.getKey(), "UTF-8"), URLEncoder.encode(entry.getValue(), "UTF-8"));
                    }
                    requestBody = params.replaceFirst("&", "");
                }
                if (this.debugMode) {
                    this.logger.info("RequestData: {}", this.requestData);
                    this.logger.info("RequestBody: {}", (Object)requestBody);
                }
                OutputStreamWriter osw = new OutputStreamWriter(this.connection.getOutputStream(), "UTF-8");
                Object object = null;
                try {
                    osw.write(requestBody);
                    osw.flush();
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (osw != null) {
                        if (object != null) {
                            try {
                                osw.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            osw.close();
                        }
                    }
                }
            }
            this.responseCode = this.connection.getResponseCode();
            InputStream is = this.responseCode != 200 && this.responseCode != 204 ? this.connection.getErrorStream() : this.connection.getInputStream();
            this.checkApiConnection(is);
            try (BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));){
                String line;
                resp = new StringBuffer();
                while ((line = rd.readLine()) != null) {
                    resp.append(line);
                }
            }
            String responseString = resp.toString();
            if (this.debugMode) {
                if (this.responseCode == 200 || this.responseCode == 204) {
                    this.logger.info("Response OK: {}", (Object)responseString);
                } else {
                    this.logger.info("Response ERROR: {}", (Object)responseString);
                }
            }
            if (this.responseCode == 200) {
                this.readResponseHeaders(this.connection);
                response = (Dto)this.castResponseToEntity(classOfT, JsonParser.parseString((String)responseString).getAsJsonObject());
                if (this.debugMode) {
                    this.logger.info("Response object: {}", (Object)response.toString());
                }
            }
            this.checkResponseCode(responseString);
        }
        catch (Exception ex) {
            if (this.debugMode) {
                this.logger.error("EXCEPTION: {}", (Object)Arrays.toString(ex.getStackTrace()));
            }
            throw ex;
        }
        return (T)response;
    }

    private void configureSslContext(HttpsURLConnection connection) throws KeyManagementException, NoSuchAlgorithmException {
        connection.setSSLSocketFactory(this.getSSLContext().getSocketFactory());
    }

    private SSLContext getSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(null, null, new SecureRandom());
        return sslContext;
    }

    private void readResponseHeaders(HttpURLConnection conn) {
        List<RateLimit> updatedRateLimits = null;
        for (Map.Entry<String, List<String>> k : conn.getHeaderFields().entrySet()) {
            for (String v : k.getValue()) {
                String linkValue;
                String[] links;
                if (this.debugMode) {
                    this.logger.info("Response header: {}", (Object)(k.getKey() + ":" + v));
                }
                if (k.getKey() == null) continue;
                if (k.getKey().equals("X-RateLimit-Remaining") || k.getKey().equals("X-RateLimit-Remaining".toLowerCase())) {
                    if (updatedRateLimits == null) {
                        updatedRateLimits = this.initRateLimits();
                    }
                    List<String> callsRemaining = k.getValue();
                    updatedRateLimits.get(0).setCallsRemaining(Integer.valueOf(callsRemaining.get(3)));
                    updatedRateLimits.get(1).setCallsRemaining(Integer.valueOf(callsRemaining.get(2)));
                    updatedRateLimits.get(2).setCallsRemaining(Integer.valueOf(callsRemaining.get(1)));
                    updatedRateLimits.get(3).setCallsRemaining(Integer.valueOf(callsRemaining.get(0)));
                }
                if (k.getKey().equals("X-RateLimit") || k.getKey().equals("X-RateLimit".toLowerCase())) {
                    if (updatedRateLimits == null) {
                        updatedRateLimits = this.initRateLimits();
                    }
                    List<String> callsMade = k.getValue();
                    updatedRateLimits.get(0).setCallsMade(Integer.valueOf(callsMade.get(3)));
                    updatedRateLimits.get(1).setCallsMade(Integer.valueOf(callsMade.get(2)));
                    updatedRateLimits.get(2).setCallsMade(Integer.valueOf(callsMade.get(1)));
                    updatedRateLimits.get(3).setCallsMade(Integer.valueOf(callsMade.get(0)));
                }
                if (k.getKey().equals("X-RateLimit-Reset") || k.getKey().equals("X-RateLimit-Reset".toLowerCase())) {
                    if (updatedRateLimits == null) {
                        updatedRateLimits = this.initRateLimits();
                    }
                    List<String> resetTimes = k.getValue();
                    updatedRateLimits.get(0).setResetTimeSeconds(Long.valueOf(resetTimes.get(3)));
                    updatedRateLimits.get(1).setResetTimeSeconds(Long.valueOf(resetTimes.get(2)));
                    updatedRateLimits.get(2).setResetTimeSeconds(Long.valueOf(resetTimes.get(1)));
                    updatedRateLimits.get(3).setResetTimeSeconds(Long.valueOf(resetTimes.get(0)));
                }
                if (k.getKey().equals("X-Number-Of-Pages") || k.getKey().equals("X-Number-Of-Pages".toLowerCase())) {
                    this.pagination.setTotalPages(Integer.parseInt(v));
                }
                if (k.getKey().equals("X-Number-Of-Items") || k.getKey().equals("X-Number-Of-Items".toLowerCase())) {
                    this.pagination.setTotalItems(Integer.parseInt(v));
                }
                if (!k.getKey().equals("Link") && !k.getKey().equals("Link".toLowerCase()) || (links = (linkValue = v).split(",")) == null || links.length <= 0) continue;
                for (String link : links) {
                    link = link.replaceAll(Matcher.quoteReplacement("<\""), "");
                    link = link.replaceAll(Matcher.quoteReplacement("\">"), "");
                    link = link.replaceAll(Matcher.quoteReplacement(" rel=\""), "");
                    String[] oneLink = (link = link.replaceAll(Matcher.quoteReplacement("\""), "")).split(";");
                    if (oneLink == null || oneLink.length <= 1 || oneLink[0] == null || oneLink[1] == null) continue;
                    this.pagination.setLinks(oneLink);
                }
            }
        }
        if (updatedRateLimits != null) {
            this.root.setRateLimits(updatedRateLimits);
        }
    }

    private List<RateLimit> initRateLimits() {
        return Arrays.asList(new RateLimit(15), new RateLimit(30), new RateLimit(60), new RateLimit(1440));
    }

    public <T> T castResponseToEntity(Class<T> classOfT, JsonObject response) {
        return (T)this.root.getGson().fromJson((JsonElement)response, classOfT);
    }

    private <T extends Dto> List<T> doRequestList(Class<T[]> classOfT, Class<T> classOfTItem, String urlMethod, Pagination pagination) throws Exception {
        return this.doRequestList(classOfT, classOfTItem, urlMethod, pagination, null);
    }

    private <T extends Dto> List<T> doRequestList(Class<T[]> classOfT, Class<T> classOfTItem, String urlMethod, Pagination pagination, Map<String, String> additionalUrlParams) throws Exception {
        ArrayList<Dto> response = new ArrayList<Dto>();
        try {
            StringBuffer resp;
            UrlTool urlTool = new UrlTool(this.root);
            String restUrl = urlTool.getRestUrl(urlMethod, this.clientIdRequired, pagination, additionalUrlParams);
            URL url = new URL(urlTool.getFullUrl(restUrl));
            if (this.debugMode) {
                this.logger.info("FullUrl: {}", (Object)urlTool.getFullUrl(restUrl));
            }
            this.connection = (HttpURLConnection)url.openConnection();
            if (this.connection instanceof HttpsURLConnection) {
                this.configureSslContext((HttpsURLConnection)this.connection);
            }
            this.connection.setRequestMethod(this.requestType);
            Map<String, String> httpHeaders = this.getHttpHeaders(restUrl);
            for (Map.Entry<String, String> entry2 : httpHeaders.entrySet()) {
                this.connection.addRequestProperty(entry2.getKey(), entry2.getValue());
                if (!this.debugMode) continue;
                this.logger.info("HTTP Header: {}", (Object)(entry2.getKey() + ": " + entry2.getValue()));
            }
            this.connection.setUseCaches(false);
            this.connection.setDoInput(true);
            this.connection.setDoOutput(true);
            if (pagination != null) {
                this.pagination = pagination;
            }
            if (this.debugMode) {
                this.logger.info("RequestType: {}", (Object)this.requestType);
            }
            if (this.requestData != null) {
                String params = "";
                for (Map.Entry<String, String> entry : this.requestData.entrySet()) {
                    params = params + String.format("&%s=%s", URLEncoder.encode(entry.getKey(), "UTF-8"), URLEncoder.encode(entry.getValue(), "UTF-8"));
                }
                String requestBody = params.replaceFirst("&", "");
                this.writeRequestBody(this.connection, requestBody);
                if (this.debugMode) {
                    this.logger.info("RequestData: {}", this.requestData);
                    this.logger.info("RequestBody: {}", (Object)requestBody);
                }
            } else if (restUrl.contains("consult") && (restUrl.contains("KYC/documents") || restUrl.contains("dispute-documents"))) {
                this.writeRequestBody(this.connection, "");
            }
            this.responseCode = this.connection.getResponseCode();
            InputStream is = this.responseCode != 200 ? this.connection.getErrorStream() : this.connection.getInputStream();
            this.checkApiConnection(is);
            Throwable throwable = null;
            try (BufferedReader rd = new BufferedReader(new InputStreamReader(is));){
                String line;
                resp = new StringBuffer();
                while ((line = rd.readLine()) != null) {
                    resp.append(line);
                    resp.append('\r');
                }
            }
            catch (Throwable line) {
                Throwable throwable2 = line;
                throw line;
            }
            String responseString = resp.toString();
            if (this.debugMode) {
                if (this.responseCode == 200) {
                    this.logger.info("Response OK: {}", (Object)responseString);
                } else {
                    this.logger.info("Response ERROR: {}", (Object)responseString);
                }
            }
            if (this.responseCode == 200) {
                this.readResponseHeaders(this.connection);
                JsonArray jsonArray = JsonParser.parseString((String)responseString).getAsJsonArray();
                for (int x = 0; x < jsonArray.size(); ++x) {
                    JsonObject jo = jsonArray.get(x).getAsJsonObject();
                    Dto toAdd = (Dto)this.castResponseToEntity(classOfTItem, jo);
                    response.add(toAdd);
                }
                if (this.debugMode) {
                    this.logger.info("Response object: {}", (Object)((Object)response).toString());
                    this.logger.info("Elements count: {}", (Object)response.size());
                }
            }
            this.checkResponseCode(responseString);
        }
        catch (Exception ex) {
            if (this.debugMode) {
                this.logger.error("EXCEPTION: {}", (Object)Arrays.toString(ex.getStackTrace()));
            }
            throw ex;
        }
        return response;
    }

    private void writeRequestBody(HttpURLConnection connection, String body) throws IOException {
        try (DataOutputStream wr = new DataOutputStream(connection.getOutputStream());){
            wr.writeBytes(body);
            wr.flush();
        }
    }

    private Map<String, String> getHttpHeaders(String restUrl) throws Exception {
        if (this.requestHttpHeaders != null) {
            return this.requestHttpHeaders;
        }
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Content-Type", "application/json");
        if (this.authRequired) {
            AuthenticationHelper authHlp = new AuthenticationHelper(this.root);
            httpHeaders.putAll(authHlp.getHttpHeaderKey());
        }
        httpHeaders.put("User-Agent", String.format("MangoPay V2 SDK Java %s", this.root.getConfig().getVersion()));
        return httpHeaders;
    }

    private void checkApiConnection(InputStream is) throws ResponseException {
        if (is == null) {
            ResponseException responseException = new ResponseException("Connection to Mangopay API failed");
            responseException.setResponseHttpCode(500);
            responseException.setResponseHttpDescription("Internal Server Error");
            responseException.setApiMessage("Connection to Mangopay API failed");
            throw responseException;
        }
    }

    private void checkResponseCode(String message) throws ResponseException {
        if (this.responseCode != 200 && this.responseCode != 204) {
            HashMap<Integer, String> responseCodes = new HashMap<Integer, String>(){
                {
                    this.put(206, "PartialContent");
                    this.put(400, "Bad request");
                    this.put(401, "Unauthorized");
                    this.put(403, "Prohibition to use the method");
                    this.put(404, "Not found");
                    this.put(405, "Method not allowed");
                    this.put(413, "Request entity too large");
                    this.put(422, "Unprocessable entity");
                    this.put(500, "Internal server error");
                    this.put(501, "Not implemented");
                }
            };
            ResponseException responseException = new ResponseException(message);
            responseException.setResponseHttpCode(this.responseCode);
            if (responseCodes.containsKey(this.responseCode)) {
                responseException.setResponseHttpDescription((String)responseCodes.get(this.responseCode));
            } else {
                responseException.setResponseHttpDescription("Unknown response error");
            }
            if (message != null) {
                try {
                    JsonObject error = JsonParser.parseString((String)message).getAsJsonObject();
                    for (Map.Entry entry : error.entrySet()) {
                        switch (((String)entry.getKey()).toLowerCase()) {
                            case "message": {
                                responseException.setApiMessage(((JsonElement)entry.getValue()).getAsString());
                                break;
                            }
                            case "type": {
                                responseException.setType(((JsonElement)entry.getValue()).getAsString());
                                break;
                            }
                            case "id": {
                                responseException.setId(((JsonElement)entry.getValue()).getAsString());
                                break;
                            }
                            case "date": {
                                responseException.setDate((int)((JsonElement)entry.getValue()).getAsDouble());
                                break;
                            }
                            case "errors": {
                                if (entry.getValue() == null || ((JsonElement)entry.getValue()).isJsonNull()) break;
                                for (Map.Entry errorEntry : ((JsonElement)entry.getValue()).getAsJsonObject().entrySet()) {
                                    if (!responseException.getErrors().containsKey(errorEntry.getKey())) {
                                        responseException.getErrors().put((String)errorEntry.getKey(), ((JsonElement)errorEntry.getValue()).getAsString());
                                        continue;
                                    }
                                    String description = responseException.getErrors().get(errorEntry.getKey());
                                    description = " | " + ((JsonElement)errorEntry.getValue()).getAsString();
                                    responseException.getErrors().put((String)errorEntry.getKey(), description);
                                }
                                break;
                            }
                        }
                    }
                }
                catch (JsonSyntaxException | IllegalStateException ex) {
                    responseException.setType("Resource not found");
                    responseException.setApiMessage("API Endpoint not found");
                }
            }
            throw responseException;
        }
    }
}

