/*
 * Decompiled with CFR 0.152.
 */
package com.mangopay.core;

import com.mangopay.MangoPayApi;
import com.mangopay.core.Pagination;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;

class UrlTool {
    private MangoPayApi root;

    public UrlTool(MangoPayApi root) {
        this.root = root;
    }

    private String getHost() throws Exception {
        if (this.root.getConfig().getBaseUrl() == null || this.root.getConfig().getBaseUrl().length() == 0) {
            throw new Exception("MangoPayApi.config.BaseUrl setting is not defined.");
        }
        URL baseUrl = new URL(this.root.getConfig().getBaseUrl());
        return baseUrl.getHost();
    }

    public String getRestUrl(String urlKey) throws UnsupportedEncodingException {
        return this.getRestUrl(urlKey, true, null, null);
    }

    public String getRestUrl(String urlKey, Boolean addClientId) throws UnsupportedEncodingException {
        return this.getRestUrl(urlKey, addClientId, null, null);
    }

    public String getRestUrl(String urlKey, Boolean addClientId, Pagination pagination) throws UnsupportedEncodingException {
        return this.getRestUrl(urlKey, addClientId, pagination, null);
    }

    public String getRestUrl(String urlKey, Boolean addClientId, Pagination pagination, Map<String, String> additionalUrlParams) throws UnsupportedEncodingException {
        String url = addClientId == false ? "/v2.01" + urlKey : "/v2.01/" + this.root.getConfig().getClientId() + urlKey;
        Boolean paramsAdded = false;
        if (pagination != null) {
            url = url + "?page=" + pagination.getPage() + "&per_page=" + pagination.getItemsPerPage();
            paramsAdded = true;
        }
        if (additionalUrlParams != null) {
            for (Map.Entry<String, String> entry : additionalUrlParams.entrySet()) {
                url = url + (paramsAdded != false ? "&" : "?");
                url = url + entry.getKey() + "=" + URLEncoder.encode(entry.getValue(), "ISO-8859-1");
                paramsAdded = true;
            }
        }
        return url;
    }

    public String getFullUrl(String restUrl) {
        String result = "";
        try {
            int port = new URL(this.root.getConfig().getBaseUrl()).getPort();
            String protocol = new URL(this.root.getConfig().getBaseUrl()).getProtocol() + "://" + this.getHost();
            result = port > 0 ? protocol + ":" + port + restUrl : protocol + restUrl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

