/*
 * Decompiled with CFR 0.152.
 */
package com.mangopay.core.deserializer;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mangopay.core.enumerations.BankingAliasType;
import com.mangopay.entities.BankingAlias;
import com.mangopay.entities.subentities.BankingAliasDetailsIBAN;
import java.lang.reflect.Type;

public class BankingAliasDeserializer
implements JsonDeserializer<BankingAlias> {
    public BankingAlias deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        BankingAlias bankingAlias = (BankingAlias)new Gson().fromJson(jsonObject.toString(), BankingAlias.class);
        BankingAliasType type = bankingAlias.getType();
        switch (type) {
            case IBAN: {
                BankingAliasDetailsIBAN bankingAliasDetailsIBAN = new BankingAliasDetailsIBAN();
                bankingAliasDetailsIBAN.setBIC(jsonObject.get("BIC").getAsString());
                bankingAliasDetailsIBAN.setIBAN(jsonObject.get("IBAN").getAsString());
                bankingAlias.setDetails(bankingAliasDetailsIBAN);
            }
        }
        return bankingAlias;
    }
}

