/*
 * Decompiled with CFR 0.152.
 */
package com.mangopay.core.deserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mangopay.core.enumerations.PersonType;
import com.mangopay.entities.User;
import com.mangopay.entities.UserLegal;
import com.mangopay.entities.UserNatural;
import java.lang.reflect.Type;

public class UserDeserializer
implements JsonDeserializer<User> {
    public User deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        PersonType type = PersonType.valueOf(jsonObject.get("PersonType").getAsString());
        if (type.equals((Object)PersonType.LEGAL)) {
            return (User)context.deserialize(json, UserLegal.class);
        }
        if (type.equals((Object)PersonType.NATURAL)) {
            return (User)context.deserialize(json, UserNatural.class);
        }
        throw new IllegalArgumentException("Invalid user JSON:" + json.getAsJsonObject().toString());
    }
}

