/*
 * Decompiled with CFR 0.152.
 */
package com.mangopay.core.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mangopay.core.serializer.SerializedTransaction;
import com.mangopay.entities.PayIn;
import com.mangopay.entities.subentities.PayInExecutionDetailsBankingAlias;
import com.mangopay.entities.subentities.PayInExecutionDetailsDirect;
import com.mangopay.entities.subentities.PayInExecutionDetailsWeb;
import com.mangopay.entities.subentities.PayInPaymentDetailsApplePay;
import com.mangopay.entities.subentities.PayInPaymentDetailsBankWire;
import com.mangopay.entities.subentities.PayInPaymentDetailsBlik;
import com.mangopay.entities.subentities.PayInPaymentDetailsCard;
import com.mangopay.entities.subentities.PayInPaymentDetailsDirectDebit;
import com.mangopay.entities.subentities.PayInPaymentDetailsGiropay;
import com.mangopay.entities.subentities.PayInPaymentDetailsGooglePay;
import com.mangopay.entities.subentities.PayInPaymentDetailsGooglePayV2;
import com.mangopay.entities.subentities.PayInPaymentDetailsIdeal;
import com.mangopay.entities.subentities.PayInPaymentDetailsKlarna;
import com.mangopay.entities.subentities.PayInPaymentDetailsMbway;
import com.mangopay.entities.subentities.PayInPaymentDetailsMultibanco;
import com.mangopay.entities.subentities.PayInPaymentDetailsPayPal;
import com.mangopay.entities.subentities.PayInPaymentDetailsPayconiq;
import com.mangopay.entities.subentities.PayInPaymentDetailsPreAuthorized;
import com.mangopay.entities.subentities.PayInPaymentDetailsSatispay;
import java.lang.reflect.Type;

public class PayInSerializer
implements JsonSerializer<PayIn> {
    public JsonElement serialize(PayIn src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = SerializedTransaction.getTransactionObject(src, context);
        object.add("CreditedWalletId", context.serialize((Object)src.getCreditedWalletId()));
        object.add("PaymentType", context.serialize((Object)src.getPaymentType()));
        object.add("ExecutionType", context.serialize((Object)src.getExecutionType()));
        object.add("ExecutionDetails", context.serialize((Object)src.getExecutionDetails()));
        switch (src.getPaymentDetails().getClass().getSimpleName()) {
            case "PayInPaymentDetailsBankWire": {
                object.add("DeclaredDebitedFunds", context.serialize((Object)((PayInPaymentDetailsBankWire)src.getPaymentDetails()).getDeclaredDebitedFunds()));
                object.add("DeclaredFees", context.serialize((Object)((PayInPaymentDetailsBankWire)src.getPaymentDetails()).getDeclaredFees()));
                object.add("BankAccount", context.serialize((Object)((PayInPaymentDetailsBankWire)src.getPaymentDetails()).getBankAccount()));
                object.add("WireReference", context.serialize((Object)((PayInPaymentDetailsBankWire)src.getPaymentDetails()).getWireReference()));
                break;
            }
            case "PayInPaymentDetailsCard": {
                object.add("CardType", context.serialize((Object)((PayInPaymentDetailsCard)src.getPaymentDetails()).getCardType()));
                object.add("CardId", context.serialize((Object)((PayInPaymentDetailsCard)src.getPaymentDetails()).getCardId()));
                object.add("StatementDescriptor", context.serialize((Object)((PayInPaymentDetailsCard)src.getPaymentDetails()).getStatementDescriptor()));
                object.add("Shipping", context.serialize((Object)((PayInPaymentDetailsCard)src.getPaymentDetails()).getShipping()));
                object.add("BrowserInfo", context.serialize((Object)((PayInPaymentDetailsCard)src.getPaymentDetails()).getBrowserInfo()));
                object.add("IpAddress", context.serialize((Object)((PayInPaymentDetailsCard)src.getPaymentDetails()).getIpAddress()));
                object.add("Bic", context.serialize((Object)((PayInPaymentDetailsCard)src.getPaymentDetails()).getBic()));
                object.add("BankName", context.serialize((Object)((PayInPaymentDetailsCard)src.getPaymentDetails()).getBankName()));
                break;
            }
            case "PayInPaymentDetailsPreAuthorized": {
                object.add("PreauthorizationId", context.serialize((Object)((PayInPaymentDetailsPreAuthorized)src.getPaymentDetails()).getPreauthorizationId()));
                object.add("Culture", context.serialize((Object)((PayInPaymentDetailsPreAuthorized)src.getPaymentDetails()).getCulture()));
                object.add("Shipping", context.serialize((Object)((PayInPaymentDetailsPreAuthorized)src.getPaymentDetails()).getShipping()));
                break;
            }
            case "PayInPaymentDetailsPayPal": {
                object.add("ShippingAddress", context.serialize((Object)((PayInPaymentDetailsPayPal)src.getPaymentDetails()).getShippingAddress()));
                object.add("PaypalBuyerAccountEmail", context.serialize((Object)((PayInPaymentDetailsPayPal)src.getPaymentDetails()).getPaypalBuyerAccountEmail()));
                object.add("StatementDescriptor", context.serialize((Object)((PayInPaymentDetailsPayPal)src.getPaymentDetails()).getStatementDescriptor()));
                object.add("Shipping", context.serialize((Object)((PayInPaymentDetailsPayPal)src.getPaymentDetails()).getShipping()));
                object.add("LineItems", context.serialize(((PayInPaymentDetailsPayPal)src.getPaymentDetails()).getLineItems()));
                object.add("ShippingPreference", context.serialize((Object)((PayInPaymentDetailsPayPal)src.getPaymentDetails()).getShippingPreference()));
                object.add("Reference", context.serialize((Object)((PayInPaymentDetailsPayPal)src.getPaymentDetails()).getReference()));
                break;
            }
            case "PayInPaymentDetailsPayconiq": {
                object.add("Country", context.serialize((Object)((PayInPaymentDetailsPayconiq)src.getPaymentDetails()).getCountry()));
                break;
            }
            case "PayInPaymentDetailsDirectDebit": {
                object.add("DirectDebitType", context.serialize((Object)((PayInPaymentDetailsDirectDebit)src.getPaymentDetails()).getDirectDebitType()));
                object.add("MandateId", context.serialize((Object)((PayInPaymentDetailsDirectDebit)src.getPaymentDetails()).getMandateId()));
                object.add("StatementDescriptor", context.serialize((Object)((PayInPaymentDetailsDirectDebit)src.getPaymentDetails()).getStatementDescriptor()));
                object.add("ChargeDate", context.serialize((Object)((PayInPaymentDetailsDirectDebit)src.getPaymentDetails()).getChargeDate()));
                object.add("Culture", context.serialize((Object)((PayInPaymentDetailsDirectDebit)src.getPaymentDetails()).getCulture()));
                break;
            }
            case "PayInPaymentDetailsApplePay": {
                object.add("PaymentData", context.serialize((Object)((PayInPaymentDetailsApplePay)src.getPaymentDetails()).getPaymentData()));
                object.add("StatementDescriptor", context.serialize((Object)((PayInPaymentDetailsApplePay)src.getPaymentDetails()).getStatementDescriptor()));
                break;
            }
            case "PayInPaymentDetailsGooglePay": {
                object.add("PaymentData", context.serialize((Object)((PayInPaymentDetailsGooglePay)src.getPaymentDetails()).getPaymentData()));
                object.add("StatementDescriptor", context.serialize((Object)((PayInPaymentDetailsGooglePay)src.getPaymentDetails()).getStatementDescriptor()));
                object.add("Billing", context.serialize((Object)((PayInPaymentDetailsGooglePay)src.getPaymentDetails()).getBilling()));
                break;
            }
            case "PayInPaymentDetailsGooglePayV2": {
                object.add("PaymentData", context.serialize((Object)((PayInPaymentDetailsGooglePayV2)src.getPaymentDetails()).getPaymentData()));
                object.add("StatementDescriptor", context.serialize((Object)((PayInPaymentDetailsGooglePayV2)src.getPaymentDetails()).getStatementDescriptor()));
                object.add("Shipping", context.serialize((Object)((PayInPaymentDetailsGooglePayV2)src.getPaymentDetails()).getShipping()));
                object.add("IpAddress", context.serialize((Object)((PayInPaymentDetailsGooglePayV2)src.getPaymentDetails()).getIpAddress()));
                object.add("BrowserInfo", context.serialize((Object)((PayInPaymentDetailsGooglePayV2)src.getPaymentDetails()).getBrowserInfo()));
                object.add("RedirectURL", context.serialize((Object)((PayInPaymentDetailsGooglePayV2)src.getPaymentDetails()).getRedirectUrl()));
                object.add("RedirectURL", context.serialize((Object)((PayInPaymentDetailsGooglePayV2)src.getPaymentDetails()).getReturnUrl()));
                break;
            }
            case "PayInPaymentDetailsMbway": {
                object.add("StatementDescriptor", context.serialize((Object)((PayInPaymentDetailsMbway)src.getPaymentDetails()).getStatementDescriptor()));
                object.add("Phone", context.serialize((Object)((PayInPaymentDetailsMbway)src.getPaymentDetails()).getPhone()));
                break;
            }
            case "PayInPaymentDetailsSatispay": {
                object.add("StatementDescriptor", context.serialize((Object)((PayInPaymentDetailsSatispay)src.getPaymentDetails()).getStatementDescriptor()));
                object.add("Country", context.serialize((Object)((PayInPaymentDetailsSatispay)src.getPaymentDetails()).getCountry()));
                break;
            }
            case "PayInPaymentDetailsBlik": {
                object.add("StatementDescriptor", context.serialize((Object)((PayInPaymentDetailsBlik)src.getPaymentDetails()).getStatementDescriptor()));
                break;
            }
            case "PayInPaymentDetailsMultibanco": {
                object.add("StatementDescriptor", context.serialize((Object)((PayInPaymentDetailsMultibanco)src.getPaymentDetails()).getStatementDescriptor()));
                break;
            }
            case "PayInPaymentDetailsKlarna": {
                object.add("LineItems", context.serialize(((PayInPaymentDetailsKlarna)src.getPaymentDetails()).getLineItems()));
                object.add("Shipping", context.serialize((Object)((PayInPaymentDetailsKlarna)src.getPaymentDetails()).getShipping()));
                object.add("Billing", context.serialize((Object)((PayInPaymentDetailsKlarna)src.getPaymentDetails()).getBilling()));
                object.add("PaymentMethod", context.serialize((Object)((PayInPaymentDetailsKlarna)src.getPaymentDetails()).getPaymentMethod()));
                object.add("Reference", context.serialize((Object)((PayInPaymentDetailsKlarna)src.getPaymentDetails()).getReference()));
                object.add("Country", context.serialize((Object)((PayInPaymentDetailsKlarna)src.getPaymentDetails()).getCountry()));
                object.add("Culture", context.serialize((Object)((PayInPaymentDetailsKlarna)src.getPaymentDetails()).getCulture()));
                object.add("Phone", context.serialize((Object)((PayInPaymentDetailsKlarna)src.getPaymentDetails()).getPhone()));
                object.add("Email", context.serialize((Object)((PayInPaymentDetailsKlarna)src.getPaymentDetails()).getEmail()));
                object.add("AdditionalData", context.serialize((Object)((PayInPaymentDetailsKlarna)src.getPaymentDetails()).getAdditionalData()));
                break;
            }
            case "PayInPaymentDetailsIdeal": {
                object.add("StatementDescriptor", context.serialize((Object)((PayInPaymentDetailsIdeal)src.getPaymentDetails()).getStatementDescriptor()));
                object.add("Bic", context.serialize((Object)((PayInPaymentDetailsIdeal)src.getPaymentDetails()).getBic()));
                object.add("BankName", context.serialize((Object)((PayInPaymentDetailsIdeal)src.getPaymentDetails()).getBankName()));
                break;
            }
            case "PayInPaymentDetailsGiropay": {
                object.add("StatementDescriptor", context.serialize((Object)((PayInPaymentDetailsGiropay)src.getPaymentDetails()).getStatementDescriptor()));
                break;
            }
            default: {
                return null;
            }
        }
        if (src.getExecutionDetails() != null) {
            switch (src.getExecutionDetails().getClass().getSimpleName()) {
                case "PayInExecutionDetailsBankingAlias": {
                    object.add("BankingAliasId", context.serialize((Object)((PayInExecutionDetailsBankingAlias)src.getExecutionDetails()).getBankingAliasId()));
                    object.add("WireReference", context.serialize((Object)((PayInExecutionDetailsBankingAlias)src.getExecutionDetails()).getWireReference()));
                    object.add("DebitedBankAccount", context.serialize((Object)((PayInExecutionDetailsBankingAlias)src.getExecutionDetails()).getDebitedBankAccount()));
                    break;
                }
                case "PayInExecutionDetailsDirect": {
                    object.add("CardId", context.serialize((Object)((PayInExecutionDetailsDirect)src.getExecutionDetails()).getCardId()));
                    object.add("SecureMode", context.serialize((Object)((PayInExecutionDetailsDirect)src.getExecutionDetails()).getSecureMode()));
                    object.add("SecureModeReturnURL", context.serialize((Object)((PayInExecutionDetailsDirect)src.getExecutionDetails()).getSecureModeReturnUrl()));
                    object.add("SecureModeRedirectURL", context.serialize((Object)((PayInExecutionDetailsDirect)src.getExecutionDetails()).getSecureModeRedirectUrl()));
                    object.add("SecureModeNeeded", context.serialize((Object)((PayInExecutionDetailsDirect)src.getExecutionDetails()).getSecureModeNeeded()));
                    object.add("Billing", context.serialize((Object)((PayInExecutionDetailsDirect)src.getExecutionDetails()).getBilling()));
                    object.add("SecurityInfo", context.serialize((Object)((PayInExecutionDetailsDirect)src.getExecutionDetails()).getSecurityInfo()));
                    object.add("Culture", context.serialize((Object)((PayInExecutionDetailsDirect)src.getExecutionDetails()).getCulture()));
                    object.add("Requested3DSVersion", context.serialize((Object)((PayInExecutionDetailsDirect)src.getExecutionDetails()).getRequested3DSVersion()));
                    break;
                }
                case "PayInExecutionDetailsWeb": {
                    object.add("TemplateURL", context.serialize((Object)((PayInExecutionDetailsWeb)src.getExecutionDetails()).getTemplateUrl()));
                    object.add("Culture", context.serialize((Object)((PayInExecutionDetailsWeb)src.getExecutionDetails()).getCulture()));
                    object.add("SecureMode", context.serialize((Object)((PayInExecutionDetailsWeb)src.getExecutionDetails()).getSecureMode()));
                    object.add("RedirectURL", context.serialize((Object)((PayInExecutionDetailsWeb)src.getExecutionDetails()).getRedirectUrl()));
                    object.add("ReturnURL", context.serialize((Object)((PayInExecutionDetailsWeb)src.getExecutionDetails()).getReturnUrl()));
                    object.add("TemplateURLOptions", context.serialize((Object)((PayInExecutionDetailsWeb)src.getExecutionDetails()).getTemplateURLOptions()));
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return object;
    }
}

