/*
 * Decompiled with CFR 0.152.
 */
package com.mangopay.entities.subentities;

import com.google.gson.annotations.SerializedName;
import com.mangopay.core.Billing;
import com.mangopay.core.Dto;
import com.mangopay.core.ObjectTool;
import com.mangopay.core.SecurityInfo;
import com.mangopay.core.enumerations.CultureCode;
import com.mangopay.core.enumerations.SecureMode;
import com.mangopay.core.interfaces.PayInExecutionDetails;
import java.lang.reflect.Type;
import java.util.Map;

public class PayInExecutionDetailsDirect
extends Dto
implements PayInExecutionDetails {
    @SerializedName(value="CardId")
    private String cardId;
    @SerializedName(value="SecureMode")
    private SecureMode secureMode;
    @SerializedName(value="SecureModeReturnURL")
    private String secureModeReturnUrl;
    @SerializedName(value="SecureModeRedirectURL")
    private String secureModeRedirectUrl;
    @SerializedName(value="SecureModeNeeded")
    private String secureModeNeeded;
    @SerializedName(value="Billing")
    private Billing billing;
    @SerializedName(value="SecurityInfo")
    private SecurityInfo securityInfo;
    @SerializedName(value="Requested3DSVersion")
    private String requested3DSVersion;
    @SerializedName(value="Applied3DSVersion")
    private String applied3DSVersion;
    @SerializedName(value="RecurringPayinRegistrationId")
    private String recurringPayInRegistrationId;
    @SerializedName(value="Culture")
    private CultureCode culture;

    public PayInExecutionDetailsDirect() {
    }

    public PayInExecutionDetailsDirect(String cardId, String secureModeReturnUrl) {
        this.cardId = cardId;
        this.secureModeReturnUrl = secureModeReturnUrl;
    }

    public PayInExecutionDetailsDirect(String cardId, SecureMode secureMode, String secureModeReturnUrl) {
        this.cardId = cardId;
        this.secureMode = secureMode;
        this.secureModeReturnUrl = secureModeReturnUrl;
    }

    public PayInExecutionDetailsDirect(String cardId, SecureMode secureMode, String secureModeReturnUrl, String secureModeRedirectUrl, String secureModeNeeded, Billing billing, SecurityInfo securityInfo, CultureCode culture) {
        this.cardId = cardId;
        this.secureMode = secureMode;
        this.secureModeReturnUrl = secureModeReturnUrl;
        this.secureModeRedirectUrl = secureModeRedirectUrl;
        this.secureModeNeeded = secureModeNeeded;
        this.billing = billing;
        this.securityInfo = securityInfo;
        this.culture = culture;
    }

    public static PayInExecutionDetailsDirect build(String cardId, String secureModeReturnURL) {
        return new PayInExecutionDetailsDirect(cardId, secureModeReturnURL);
    }

    public static PayInExecutionDetailsDirect build(String cardId, SecureMode secureMode, String secureModeReturnURL) {
        return new PayInExecutionDetailsDirect(cardId, secureMode, secureModeReturnURL);
    }

    public static PayInExecutionDetailsDirect convert(PayInExecutionDetails executionDetails) throws Exception {
        if (ObjectTool.isNull(executionDetails)) {
            throw new Exception("PayInExecutionDetails null value");
        }
        if (executionDetails instanceof PayInExecutionDetailsDirect) {
            return (PayInExecutionDetailsDirect)executionDetails;
        }
        throw new Exception("PayInExecutionDetails instance isn't PayInExecutionDetailsDirect instance");
    }

    public String getCardId() {
        return this.cardId;
    }

    public PayInExecutionDetailsDirect setCardId(String cardId) {
        this.cardId = cardId;
        return this;
    }

    public SecureMode getSecureMode() {
        return this.secureMode;
    }

    public PayInExecutionDetailsDirect setSecureMode(SecureMode secureMode) {
        this.secureMode = secureMode;
        return this;
    }

    public String getSecureModeReturnUrl() {
        return this.secureModeReturnUrl;
    }

    public PayInExecutionDetailsDirect setSecureModeReturnUrl(String secureModeReturnUrl) {
        this.secureModeReturnUrl = secureModeReturnUrl;
        return this;
    }

    public String getSecureModeRedirectUrl() {
        return this.secureModeRedirectUrl;
    }

    public PayInExecutionDetailsDirect setSecureModeRedirectUrl(String secureModeRedirectUrl) {
        this.secureModeRedirectUrl = secureModeRedirectUrl;
        return this;
    }

    public boolean isSecureModeNeeded() {
        if (ObjectTool.nonNull(this.secureModeNeeded)) {
            return Boolean.parseBoolean(this.secureModeNeeded);
        }
        return false;
    }

    public PayInExecutionDetailsDirect setSecureModeNeeded(String secureModeNeeded) {
        this.secureModeNeeded = secureModeNeeded;
        return this;
    }

    public String getSecureModeNeeded() {
        return this.secureModeNeeded;
    }

    public Billing getBilling() {
        return this.billing;
    }

    public PayInExecutionDetailsDirect setBilling(Billing billing) {
        this.billing = billing;
        return this;
    }

    public SecurityInfo getSecurityInfo() {
        return this.securityInfo;
    }

    public PayInExecutionDetailsDirect setSecurityInfo(SecurityInfo securityInfo) {
        this.securityInfo = securityInfo;
        return this;
    }

    public String getRequested3DSVersion() {
        return this.requested3DSVersion;
    }

    public PayInExecutionDetailsDirect setRequested3DSVersion(String requested3DSVersion) {
        this.requested3DSVersion = requested3DSVersion;
        return this;
    }

    public String getApplied3DSVersion() {
        return this.applied3DSVersion;
    }

    public PayInExecutionDetailsDirect setApplied3DSVersion(String applied3DSVersion) {
        this.applied3DSVersion = applied3DSVersion;
        return this;
    }

    public String getRecurringPayInRegistrationId() {
        return this.recurringPayInRegistrationId;
    }

    public PayInExecutionDetailsDirect setRecurringPayinRegistrationId(String recurringPayInRegistrationId) {
        this.recurringPayInRegistrationId = recurringPayInRegistrationId;
        return this;
    }

    @Override
    public Map<String, Type> getSubObjects() {
        Map<String, Type> result = super.getSubObjects();
        result.put("SecurityInfo", (Type)((Object)SecurityInfo.class));
        result.put("Billing", (Type)((Object)Billing.class));
        return result;
    }

    public CultureCode getCulture() {
        return this.culture;
    }

    public PayInExecutionDetailsDirect setCulture(CultureCode culture) {
        this.culture = culture;
        return this;
    }
}

