/*
 * Decompiled with CFR 0.152.
 */
package com.manoelcampos.javadoc.coverage;

import java.io.File;
import java.util.Arrays;
import java.util.stream.DoubleStream;

public final class Utils {
    private Utils() {
    }

    public static boolean isNotStringEmpty(String str) {
        return !Utils.isStringEmpty(str);
    }

    public static boolean isStringEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static String includeTrailingDirSeparator(String path) {
        if (path.trim().isEmpty()) {
            return path;
        }
        if (path.charAt(path.length() - 1) != File.separatorChar) {
            return path + File.separator;
        }
        return path;
    }

    public static double computePercentage(double partialValue, double totalValue) {
        if (totalValue == 0.0) {
            return 0.0;
        }
        return partialValue / totalValue * 100.0;
    }

    public static double mean(double ... values) {
        if (values == null) {
            return 0.0;
        }
        return Utils.average(Arrays.stream(values));
    }

    public static double average(DoubleStream stream) {
        return stream.average().orElse(0.0);
    }

    public static int boolToInt(boolean bool) {
        return bool ? 1 : 0;
    }

    public static String getFileExtension(String fileName) {
        int i = fileName.lastIndexOf(46);
        return i > 0 ? fileName.substring(i) : "";
    }
}

