/*
 * Decompiled with CFR 0.152.
 */
package com.manoelcampos.javadoc.coverage.exporter;

import com.manoelcampos.javadoc.coverage.CoverageDoclet;
import com.manoelcampos.javadoc.coverage.Utils;
import com.manoelcampos.javadoc.coverage.exporter.DataExporter;
import com.manoelcampos.javadoc.coverage.stats.JavaDocsStats;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;

public abstract class AbstractDataExporter
implements DataExporter {
    private final JavaDocsStats stats;
    private final PrintWriter writer;
    private File file;
    private final CoverageDoclet doclet;
    private final String reportFileName;

    protected AbstractDataExporter(CoverageDoclet doclet, String fileExtension) {
        this.doclet = doclet;
        if (Utils.isStringEmpty(fileExtension)) {
            this.writer = new PrintWriter(System.out);
            this.reportFileName = "";
        } else {
            this.reportFileName = this.generateReportFileName(fileExtension);
            try {
                this.writer = doclet.getWriter(this.file);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        this.stats = new JavaDocsStats(doclet.getRootDoc());
    }

    protected AbstractDataExporter(CoverageDoclet doclet) throws FileNotFoundException {
        this(doclet, "");
    }

    private String generateReportFileName(String fileExtension) {
        String fileName = this.getFileNameFromCommandLine();
        fileName = fileName + this.fileExtensionToAdd(fileName, fileExtension);
        this.file = this.doclet.getOutputFile(fileName);
        return fileName;
    }

    private String getFileNameFromCommandLine() {
        String[] outputNameOption = this.doclet.getOptionValues(CoverageDoclet.OUTPUT_NAME_OPTION);
        return outputNameOption.length > 1 ? outputNameOption[1] : "javadoc-coverage";
    }

    private String fileExtensionToAdd(String fileName, String defaultFileExtension) {
        return Utils.getFileExtension(fileName).isEmpty() ? this.getFileExtensionStartingWithDot(defaultFileExtension) : "";
    }

    private String getFileExtensionStartingWithDot(String fileExtension) {
        return fileExtension.startsWith(".") ? fileExtension : "." + fileExtension;
    }

    @Override
    public String getReportFileName() {
        return this.reportFileName;
    }

    @Override
    public boolean build() {
        try {
            this.header();
            this.exportClassesDocStats();
            this.exportPackagesDocStats();
            this.exportProjectDocumentationCoverageSummary();
            this.footer();
            this.afterBuild();
            this.getWriter().flush();
            boolean bl = true;
            return bl;
        }
        finally {
            this.getWriter().close();
        }
    }

    protected PrintWriter getWriter() {
        return this.writer;
    }

    protected JavaDocsStats getStats() {
        return this.stats;
    }

    public File getFile() {
        return this.file;
    }

    protected abstract void exportProjectDocumentationCoverageSummary();

    protected abstract void header();

    protected abstract void footer();

    protected abstract void afterBuild();

    protected abstract void exportPackagesDocStats();

    protected abstract void exportClassesDocStats();
}

