/*
 * Decompiled with CFR 0.152.
 */
package com.manoelcampos.javadoc.coverage.exporter;

import com.manoelcampos.javadoc.coverage.CoverageDoclet;
import com.manoelcampos.javadoc.coverage.Utils;
import com.manoelcampos.javadoc.coverage.exporter.AbstractDataExporter;
import com.manoelcampos.javadoc.coverage.stats.ClassDocStats;
import com.manoelcampos.javadoc.coverage.stats.ClassesDocStats;
import com.manoelcampos.javadoc.coverage.stats.MembersDocStats;
import com.manoelcampos.javadoc.coverage.stats.MethodDocStats;
import com.manoelcampos.javadoc.coverage.stats.PackagesDocStats;
import com.sun.javadoc.PackageDoc;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.List;

public class ConsoleExporter
extends AbstractDataExporter {
    public ConsoleExporter(CoverageDoclet doclet) throws FileNotFoundException {
        super(doclet);
    }

    @Override
    protected void header() {
    }

    @Override
    protected void footer() {
    }

    @Override
    public void afterBuild() {
    }

    @Override
    protected void exportProjectDocumentationCoverageSummary() {
        this.getWriter().printf("Project Documentation Coverage: %.2f%%\n\n", this.getStats().getDocumentedMembersPercent());
    }

    @Override
    protected void exportPackagesDocStats() {
        PackagesDocStats packagesDocStats = this.getStats().getPackagesDocStats();
        this.exportPkgsOrClassesDocStats(packagesDocStats);
        packagesDocStats.getPackagesDoc().forEach(pkg -> this.exportPackageDocStats((PackageDoc)pkg));
        this.getWriter().println();
    }

    private void exportPkgsOrClassesDocStats(MembersDocStats packagesDocStats) {
        this.getWriter().printf("%-26s: \t%11d Undocumented: %6d Documented: %6d (%.2f%%)\n", packagesDocStats.getType(), packagesDocStats.getMembersNumber(), packagesDocStats.getUndocumentedMembers(), packagesDocStats.getDocumentedMembers(), packagesDocStats.getDocumentedMembersPercent());
    }

    private void exportPackageDocStats(PackageDoc doc) {
        this.getWriter().printf("\tPackage %s. Documented: %s\n", doc.name(), Utils.isNotStringEmpty(doc.commentText()));
    }

    @Override
    protected void exportClassesDocStats() {
        ClassesDocStats classesDocStats = this.getStats().getClassesDocStats();
        this.exportPkgsOrClassesDocStats(classesDocStats);
        for (ClassDocStats classStats : this.getStats().getClassesDocStats().getClassesList()) {
            this.exportClassDocStats(classStats);
        }
        this.getWriter().println();
    }

    private void exportClassDocStats(ClassDocStats classStats) {
        this.getWriter().printf("\t%s: %s Package: %s Documented: %s (%.2f%%)\n", classStats.getType(), classStats.getName(), classStats.getPackageName(), classStats.hasDocumentation(), classStats.getDocumentedMembersPercent());
        this.exportMembersDocStats(this.getWriter(), classStats.getFieldsStats());
        this.exportMethodsDocStats(this.getWriter(), classStats.getConstructorsStats());
        this.exportMethodsDocStats(this.getWriter(), classStats.getMethodsStats());
        this.exportMembersDocStats(this.getWriter(), classStats.getEnumsStats());
        this.getWriter().flush();
    }

    private void exportMethodsDocStats(PrintWriter writer, List<MethodDocStats> methodStatsList) {
        String memberTypeFormat = "\t\t\t%-12s";
        for (MethodDocStats methodStats : methodStatsList) {
            writer.printf("\t\t%s: %s Documented: %s (%.2f%%)\n", methodStats.getType(), methodStats.getMethodName(), methodStats.hasDocumentation(), methodStats.getDocumentedMembersPercent());
            this.exportMembersDocStats(writer, methodStats.getParamsStats(), "\t\t\t%-12s");
            if (methodStats.getThrownExceptions().getMembersNumber() <= 0L) continue;
            this.exportMembersDocStats(writer, methodStats.getThrownExceptions(), "\t\t\t%-12s");
        }
    }

    private void exportMembersDocStats(PrintWriter writer, MembersDocStats membersDocStats) {
        this.exportMembersDocStats(writer, membersDocStats, "");
    }

    private void exportMembersDocStats(PrintWriter writer, MembersDocStats membersDocStats, String memberTypeFormat) {
        if (membersDocStats.getMembersNumber() == 0L && !membersDocStats.isPrintIfNoMembers()) {
            return;
        }
        String format = (Utils.isStringEmpty(memberTypeFormat) ? "\t\t%-20s" : memberTypeFormat) + " %6d Undocumented: %6d Documented: %6d (%.2f%%) \n";
        writer.printf(format, membersDocStats.getType() + ":", membersDocStats.getMembersNumber(), membersDocStats.getUndocumentedMembers(), membersDocStats.getDocumentedMembers(), membersDocStats.getDocumentedMembersPercent());
    }
}

