/*
 * Decompiled with CFR 0.152.
 */
package com.manoelcampos.javadoc.coverage.exporter;

import com.manoelcampos.javadoc.coverage.CoverageDoclet;
import com.manoelcampos.javadoc.coverage.Utils;
import com.manoelcampos.javadoc.coverage.exporter.AbstractDataExporter;
import com.manoelcampos.javadoc.coverage.stats.ClassDocStats;
import com.manoelcampos.javadoc.coverage.stats.MembersDocStats;
import com.manoelcampos.javadoc.coverage.stats.MethodDocStats;
import com.sun.javadoc.PackageDoc;
import java.io.FileNotFoundException;
import java.util.List;

public class HtmlExporter
extends AbstractDataExporter {
    public static final String COLUMNS = "<td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%.2f%%</td>\n";

    public HtmlExporter(CoverageDoclet doclet) throws FileNotFoundException {
        super(doclet, ".html");
    }

    @Override
    protected void exportProjectDocumentationCoverageSummary() {
        this.getWriter().printf("<tr><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%.2f%%</td>\n</tr>", "<strong>Project Documentation Coverage</strong>", "", "", "", "", "", this.getStats().getDocumentedMembersPercent());
    }

    @Override
    protected void header() {
        this.getWriter().println("<!DOCTYPE html>\n<html lang=en>");
        this.getWriter().println("<head>");
        this.getWriter().println("    <title>JavaDoc Coverage Report</title>");
        this.getWriter().println("    <meta charset='utf-8'>");
        this.getWriter().println("    <meta content='width=device-width,initial-scale=1' name=viewport>");
        this.getWriter().println("    <link rel='stylesheet' href='https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css'>\n");
        this.getWriter().println("    <script src='https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js'></script>\n");
        this.getWriter().println("</head>");
        this.getWriter().println("<body>");
        this.getWriter().println("<div class='table-responsive'> ");
        this.getWriter().println("<h2>JavaDoc Coverage Report</h2>");
        this.getWriter().println("<table class='table table-bordered'>");
        this.getWriter().println("<thead class='thead-inverse'>");
        this.getWriter().println("<tr>");
        this.getWriter().println("<th>Element Type</th><th>Name</th><th>Package</th><th>Documentable Members</th><th>Undocumented</th><th>Documented</th><th>Documented Percent</th>");
        this.getWriter().println("</tr>");
        this.getWriter().println("</thead>");
        this.getWriter().println("<tbody>");
    }

    @Override
    protected void footer() {
        this.getWriter().println("</tbody>");
        this.getWriter().println("</table>");
        this.getWriter().println("</div>");
        this.getWriter().println("</body>");
    }

    @Override
    protected void exportPackagesDocStats() {
        this.exportMembersDocStatsSummary(this.getStats().getPackagesDocStats());
        for (PackageDoc doc : this.getStats().getPackagesDocStats().getPackagesDoc()) {
            this.getWriter().println("<tr>");
            Boolean documented = Utils.isNotStringEmpty(doc.getRawCommentText());
            double coverage = Utils.boolToInt(documented) * 100;
            this.exportLine(2, "Package", doc.name(), "", "", "", documented.toString(), coverage);
        }
    }

    @Override
    protected void exportClassesDocStats() {
        this.exportMembersDocStatsSummary(this.getStats().getClassesDocStats());
        for (ClassDocStats classDocStats : this.getStats().getClassesDocStats().getClassesList()) {
            this.exportMembersDocStatsSummary(classDocStats, 2, classDocStats.getName(), classDocStats.getPackageName());
            this.exportMembersDocStatsSummary(classDocStats.getFieldsStats(), 3);
            this.exportMethodsDocStats(classDocStats.getConstructorsStats());
            this.exportMethodsDocStats(classDocStats.getMethodsStats());
        }
    }

    private void exportMethodsDocStats(List<MethodDocStats> methods) {
        for (MethodDocStats m : methods) {
            this.exportMembersDocStatsSummary(m, 4, m.getMethodName(), "");
            this.exportMembersDocStatsSummary(m.getParamsStats(), 5);
            this.exportMembersDocStatsSummary(m.getThrownExceptions(), 5);
        }
    }

    private void exportMembersDocStatsSummary(MembersDocStats membersDocStats, int indentLevel) {
        this.exportMembersDocStatsSummary(membersDocStats, indentLevel, "", "");
    }

    private void exportMembersDocStatsSummary(MembersDocStats membersDocStats) {
        this.exportMembersDocStatsSummary(membersDocStats, 1, "", "");
    }

    private void exportMembersDocStatsSummary(MembersDocStats membersDocStats, int indentLevel, String name, String pkg) {
        if (!membersDocStats.isPrintIfNoMembers() && membersDocStats.getMembersNumber() == 0L) {
            return;
        }
        this.exportLine(indentLevel, membersDocStats.getType(), name, pkg, membersDocStats.getMembersNumber(), membersDocStats.getUndocumentedMembers(), membersDocStats.getDocumentedMembers(), membersDocStats.getDocumentedMembersPercent());
    }

    private void exportLine(int indentLevel, String memberType, String name, String pkg, Long members, Long undocumented, Long documented, double documentedPercent) {
        this.exportLine(indentLevel, memberType, name, pkg, members.toString(), undocumented.toString(), documented.toString(), documentedPercent);
    }

    private void exportLine(int indentLevel, String memberType, String name, String pkg, String members, String undocumented, String documented, double documentedPercent) {
        this.getWriter().println("<tr>");
        String type = this.getIndentation(indentLevel) + memberType;
        this.getWriter().printf(COLUMNS, type, name, pkg, members, undocumented, documented, documentedPercent);
        this.getWriter().println("</tr>");
    }

    private String getIndentation(int indentLevel) {
        int len = indentLevel * 4 - 3;
        return String.format("%" + len + "s", "").replace(" ", "&nbsp;");
    }

    @Override
    public void afterBuild() {
        System.out.printf("\nJavaDoc Coverage report saved to %s\n", this.getFile().getAbsolutePath());
    }
}

