/*
 * Decompiled with CFR 0.152.
 */
package com.manoelcampos.javadoc.coverage.stats;

import com.manoelcampos.javadoc.coverage.Utils;
import com.manoelcampos.javadoc.coverage.stats.ClassMembersDocStats;
import com.manoelcampos.javadoc.coverage.stats.MembersDocStats;
import com.manoelcampos.javadoc.coverage.stats.MethodDocStats;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.AnnotationTypeElementDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MethodDoc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ClassDocStats
extends MembersDocStats {
    private final ClassDoc doc;
    private final ClassMembersDocStats fieldsStats;
    private final ClassMembersDocStats enumsStats;
    private ClassMembersDocStats annotationsStats;
    private List<MethodDocStats> methodsStats;
    private List<MethodDocStats> constructorsStats;

    public ClassDocStats(ClassDoc doc) {
        this.doc = doc;
        this.fieldsStats = new ClassMembersDocStats((Doc[])doc.fields(false), "Fields");
        this.enumsStats = new ClassMembersDocStats((Doc[])doc.enumConstants(), "Enum Consts");
        this.processMethodsDocsStats(doc);
        this.processConstructorsDocsStats(doc);
        this.processAnnotationsDocsStats(doc);
    }

    private void processAnnotationsDocsStats(ClassDoc doc) {
        this.annotationsStats = doc instanceof AnnotationTypeDoc ? new ClassMembersDocStats((Doc[])((AnnotationTypeDoc)doc).elements(), "Annotations") : new ClassMembersDocStats((Doc[])new AnnotationTypeElementDoc[0], "Annotations");
    }

    private void processConstructorsDocsStats(ClassDoc doc) {
        ConstructorDoc[] constructors = doc.constructors(false);
        this.constructorsStats = new ArrayList<MethodDocStats>(constructors.length);
        for (ConstructorDoc constructor : constructors) {
            this.constructorsStats.add(new MethodDocStats((ExecutableMemberDoc)constructor));
        }
    }

    private void processMethodsDocsStats(ClassDoc doc) {
        MethodDoc[] methods = doc.methods(false);
        this.methodsStats = new ArrayList<MethodDocStats>(methods.length);
        for (MethodDoc method : methods) {
            this.methodsStats.add(new MethodDocStats((ExecutableMemberDoc)method));
        }
    }

    @Override
    public long getDocumentedMembers() {
        return (long)Utils.boolToInt(this.hasDocumentation()) + this.fieldsStats.getDocumentedMembers() + this.enumsStats.getDocumentedMembers() + this.getDocumentedMethodMembers(this.methodsStats) + this.getDocumentedMethodMembers(this.constructorsStats) + this.annotationsStats.getDocumentedMembers();
    }

    @Override
    public long getMembersNumber() {
        return 1L + this.fieldsStats.getMembersNumber() + this.enumsStats.getMembersNumber() + this.getMethoddMembers(this.methodsStats) + this.getMethoddMembers(this.constructorsStats) + this.annotationsStats.getMembersNumber();
    }

    private long getDocumentedMethodMembers(List<MethodDocStats> methodOrConstructor) {
        return methodOrConstructor.stream().filter(MethodDocStats::hasDocumentation).count() + methodOrConstructor.stream().mapToLong(MethodDocStats::getDocumentedMembers).sum();
    }

    private long getMethoddMembers(List<MethodDocStats> methodOrConstructor) {
        return (long)methodOrConstructor.size() + methodOrConstructor.stream().mapToLong(MethodDocStats::getMembersNumber).sum();
    }

    public String getName() {
        return this.doc.name();
    }

    public String getPackageName() {
        return this.doc.containingPackage().name();
    }

    @Override
    public String getType() {
        return this.doc.isInterface() ? "Interface" : (this.doc.isEnum() ? "Enum" : "Class");
    }

    @Override
    public boolean hasDocumentation() {
        return Utils.isNotStringEmpty(this.doc.getRawCommentText());
    }

    public ClassMembersDocStats getFieldsStats() {
        return this.fieldsStats;
    }

    public ClassMembersDocStats getEnumsStats() {
        return this.enumsStats;
    }

    public ClassMembersDocStats getAnnotationsStats() {
        return this.annotationsStats;
    }

    public List<MethodDocStats> getMethodsStats() {
        return Collections.unmodifiableList(this.methodsStats);
    }

    public List<MethodDocStats> getConstructorsStats() {
        return Collections.unmodifiableList(this.constructorsStats);
    }

    public ClassDoc getDoc() {
        return this.doc;
    }
}

