/*
 * Decompiled with CFR 0.152.
 */
package com.manoelcampos.javadoc.coverage.stats;

import com.manoelcampos.javadoc.coverage.Utils;
import com.manoelcampos.javadoc.coverage.stats.ClassDocStats;
import com.manoelcampos.javadoc.coverage.stats.MembersDocStats;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ClassesDocStats
extends MembersDocStats {
    private final List<ClassDocStats> classesDocStats;

    public ClassesDocStats(ClassDoc[] docs) {
        this.classesDocStats = new ArrayList<ClassDocStats>(docs.length);
        for (ClassDoc doc : docs) {
            this.classesDocStats.add(new ClassDocStats(doc));
        }
    }

    @Override
    public long getMembersNumber() {
        return this.classesDocStats.size();
    }

    @Override
    public String getType() {
        return "Classes/Interfaces/Enums";
    }

    @Override
    public long getDocumentedMembers() {
        return this.classesDocStats.stream().map(ClassDocStats::getDoc).map(Doc::getRawCommentText).filter(Utils::isNotStringEmpty).count();
    }

    public List<ClassDocStats> getClassesList() {
        return Collections.unmodifiableList(this.classesDocStats);
    }

    @Override
    public boolean hasDocumentation() {
        return false;
    }
}

