/*
 * Decompiled with CFR 0.152.
 */
package com.manoelcampos.javadoc.coverage.stats;

import com.manoelcampos.javadoc.coverage.Utils;
import com.manoelcampos.javadoc.coverage.stats.ClassesDocStats;
import com.manoelcampos.javadoc.coverage.stats.DocStats;
import com.manoelcampos.javadoc.coverage.stats.PackagesDocStats;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.RootDoc;

public class JavaDocsStats
implements DocStats {
    private final RootDoc rootDoc;
    private final PackagesDocStats packagesDocStats;
    private final ClassesDocStats classesDocStats;

    public JavaDocsStats(RootDoc rootDoc) {
        this.rootDoc = rootDoc;
        this.classesDocStats = new ClassesDocStats(rootDoc.classes());
        this.packagesDocStats = this.computePackagesDocsStats();
    }

    private PackagesDocStats computePackagesDocsStats() {
        PackagesDocStats stats = new PackagesDocStats();
        for (ClassDoc doc : this.rootDoc.classes()) {
            stats.addPackageDoc(doc.containingPackage());
        }
        return stats;
    }

    public PackagesDocStats getPackagesDocStats() {
        return this.packagesDocStats;
    }

    public ClassesDocStats getClassesDocStats() {
        return this.classesDocStats;
    }

    @Override
    public String getType() {
        return "Project JavaDoc Statistics";
    }

    @Override
    public long getDocumentedMembers() {
        return this.packagesDocStats.getDocumentedMembers() + this.classesDocStats.getDocumentedMembers();
    }

    @Override
    public double getDocumentedMembersPercent() {
        return Utils.mean(this.packagesDocStats.getDocumentedMembersPercent(), this.classesDocStats.getDocumentedMembersPercent());
    }

    @Override
    public long getMembersNumber() {
        return this.classesDocStats.getMembersNumber() + this.packagesDocStats.getMembersNumber();
    }
}

