/*
 * Decompiled with CFR 0.152.
 */
package com.manoelcampos.javadoc.coverage.stats;

import com.manoelcampos.javadoc.coverage.Utils;
import com.manoelcampos.javadoc.coverage.stats.MembersDocStats;
import com.manoelcampos.javadoc.coverage.stats.MethodExceptionsDocStats;
import com.manoelcampos.javadoc.coverage.stats.MethodParamsDocStats;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.Tag;
import java.util.Arrays;

public class MethodDocStats
extends MembersDocStats {
    private final ExecutableMemberDoc doc;
    private final MethodParamsDocStats paramsStats;
    private final MethodExceptionsDocStats thrownExceptions;

    MethodDocStats(ExecutableMemberDoc doc) {
        this.doc = doc;
        this.paramsStats = new MethodParamsDocStats(doc);
        this.thrownExceptions = new MethodExceptionsDocStats(doc);
        this.enablePrintIfNoMembers();
    }

    public boolean isReturnValueDocumented() {
        return Arrays.stream(this.doc.tags()).filter(tag -> "@return".equals(tag.name())).map(Tag::text).anyMatch(Utils::isNotStringEmpty);
    }

    public String getMethodName() {
        return this.doc.name();
    }

    @Override
    public String getType() {
        return this.doc.isConstructor() ? "Constructor" : "Method";
    }

    public MethodParamsDocStats getParamsStats() {
        return this.paramsStats;
    }

    public MethodExceptionsDocStats getThrownExceptions() {
        return this.thrownExceptions;
    }

    @Override
    public long getDocumentedMembers() {
        return 0L;
    }

    @Override
    public double getDocumentedMembersPercent() {
        double documentedMembers = (long)Utils.boolToInt(this.hasDocumentation()) + this.paramsStats.getDocumentedMembers() + this.thrownExceptions.getDocumentedMembers();
        return Utils.computePercentage(documentedMembers, 1L + this.getMembersNumber());
    }

    @Override
    public long getMembersNumber() {
        return this.paramsStats.getMembersNumber() + this.thrownExceptions.getMembersNumber();
    }

    @Override
    public boolean hasDocumentation() {
        return Utils.isNotStringEmpty(this.doc.getRawCommentText());
    }
}

