/*
 * Decompiled with CFR 0.152.
 */
package com.manticore.h2;

import com.manticore.h2.Schema;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;
import java.util.logging.Logger;

public class Catalog
implements Comparable<Catalog> {
    public static final Logger LOGGER = Logger.getLogger(Catalog.class.getName());
    String tableCatalog;
    String catalogSeparator;
    TreeMap<String, Schema> schemas = new TreeMap();

    public Catalog(String tableCatalog, String catalogSeparator) {
        this.tableCatalog = tableCatalog != null ? tableCatalog : "";
        this.catalogSeparator = catalogSeparator != null ? catalogSeparator : ".";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Catalog> getCatalogs(DatabaseMetaData metaData) throws SQLException {
        ArrayList<Catalog> catalogs = new ArrayList<Catalog>();
        ResultSet rs = null;
        try {
            rs = metaData.getCatalogs();
            String catalogSeparator = metaData.getCatalogSeparator();
            while (rs.next()) {
                String tableCatalog = rs.getString("TABLE_CAT");
                Catalog catalog = new Catalog(tableCatalog, catalogSeparator);
                catalogs.add(catalog);
            }
            if (catalogs.isEmpty()) {
                catalogs.add(new Catalog("", "."));
            }
        }
        finally {
            try {
                if (rs != null && !rs.isClosed()) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
        }
        return catalogs;
    }

    public Schema put(Schema schema) {
        return this.schemas.put(schema.tableSchema.toUpperCase(), schema);
    }

    public Schema get(String tableSchema) {
        return this.schemas.get(tableSchema.toUpperCase());
    }

    @Override
    public int compareTo(Catalog o) {
        return this.tableCatalog.compareToIgnoreCase(o.tableCatalog);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Catalog)) {
            return false;
        }
        Catalog catalog = (Catalog)o;
        return this.tableCatalog.equals(catalog.tableCatalog);
    }

    public int hashCode() {
        return this.tableCatalog.hashCode();
    }
}

