/*
 * Decompiled with CFR 0.152.
 */
package com.manticore.h2;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class DriverRecord
implements Comparable<DriverRecord> {
    public static final Logger LOGGER = Logger.getLogger(DriverRecord.class.getName());
    private static final ArrayList<String> BUILD_ID_LIST = new ArrayList();
    int majorVersion;
    int minorVersion;
    int patchId;
    String buildId;
    URL url;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DriverRecord(int majorVersion, int minorVersion, int patchID, String buildId, URL url) {
        if (buildId != null && !buildId.isEmpty()) {
            ArrayList<String> arrayList = BUILD_ID_LIST;
            synchronized (arrayList) {
                if (BUILD_ID_LIST.isEmpty()) {
                    try (InputStream in = ClassLoader.getSystemResourceAsStream("com/manticore/h2/h2-git.log");){
                        for (String line : IOUtils.readLines((InputStream)in, (Charset)Charset.defaultCharset())) {
                            String id = line.split(" ", 2)[0];
                            BUILD_ID_LIST.add(id);
                        }
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.patchId = patchID;
        this.buildId = buildId == null || buildId.isBlank() ? "" : buildId;
        this.url = url;
    }

    @Override
    public int compareTo(DriverRecord t) {
        int compareTo = Integer.compare(this.majorVersion, t.majorVersion);
        if (compareTo == 0) {
            compareTo = Integer.compare(this.minorVersion, t.minorVersion);
        }
        if (compareTo == 0) {
            compareTo = Integer.compare(this.patchId, t.patchId);
        }
        if (compareTo == 0) {
            if (this.buildId.isEmpty() && !t.buildId.isEmpty()) {
                compareTo = -1;
            } else if (!this.buildId.isEmpty() && t.buildId.isEmpty()) {
                compareTo = 1;
            } else if (!this.buildId.isEmpty() && !t.buildId.isEmpty()) {
                int i1 = BUILD_ID_LIST.indexOf(this.buildId);
                int i2 = BUILD_ID_LIST.indexOf(t.buildId);
                compareTo = Integer.compare(i1, i2);
            }
        }
        return compareTo;
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + this.majorVersion;
        hash = 41 * hash + this.minorVersion;
        hash = 41 * hash + this.patchId;
        hash = 41 * hash + Objects.hashCode(this.buildId);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DriverRecord other = (DriverRecord)obj;
        if (this.majorVersion != other.majorVersion) {
            return false;
        }
        if (this.minorVersion != other.minorVersion) {
            return false;
        }
        if (this.patchId != other.patchId) {
            return false;
        }
        return Objects.equals(this.buildId, other.buildId);
    }

    public String getVersion() {
        return this.majorVersion + "." + this.minorVersion + "." + this.patchId + (String)(!this.buildId.isEmpty() ? "-" + this.buildId : "");
    }

    public String toString() {
        return "H2-" + this.getVersion();
    }
}

