/*
 * Decompiled with CFR 0.152.
 */
package com.manticore.h2;

import com.manticore.h2.H2MigrationUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ErrorDialog
extends JDialog {
    public JTextArea messageField = new JTextArea(3, 42);
    public JScrollPane messageScrollPane = new JScrollPane(this.messageField, 20, 31);
    public JTextArea traceField = new JTextArea(16, 42);
    public JScrollPane traceScrollPane = new JScrollPane(this.traceField, 20, 30);
    public Action traceAction = new AbstractAction("Show Details", H2MigrationUI.SEARCH_16_ICON){

        @Override
        public void actionPerformed(ActionEvent e) {
            JToggleButton b = (JToggleButton)e.getSource();
            ErrorDialog.this.traceScrollPane.setVisible(b.isSelected());
            ErrorDialog.this.pack();
        }
    };
    public Action closeAction = new AbstractAction("Close", H2MigrationUI.DIALOG_CANCEL_16_ICON){

        @Override
        public void actionPerformed(ActionEvent e) {
            ErrorDialog.this.setVisible(false);
        }
    };
    public Action emailAction = new AbstractAction("Send E-Mail", H2MigrationUI.MAIL_NEW_16_ICON){

        @Override
        public void actionPerformed(ActionEvent e) {
            Desktop desktop;
            if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.MAIL)) {
                try {
                    String mailTo = URLEncoder.encode("support@manticore-projects.com", "UTF-8");
                    String cc = URLEncoder.encode("andreas@manticore-projects.com", "UTF-8");
                    String subject = URLEncoder.encode(ErrorDialog.this.messageField.getText(), "UTF-8");
                    String body = URLEncoder.encode(ErrorDialog.this.traceField.getText(), "UTF-8");
                    String mailURIStr = String.format("mailto:%s?subject=%s&cc=%s&body=%s", mailTo, subject, cc, body);
                    URI mailURI = new URI(mailURIStr);
                    desktop.mail(mailURI);
                }
                catch (Exception ex) {
                    Logger.getLogger(ErrorDialog.class.getName()).log(Level.SEVERE, "Sending Email through Desktop", ex);
                }
            } else {
                JOptionPane.showMessageDialog(ErrorDialog.this, "Desktop Extension is not supported.");
            }
        }
    };

    public ErrorDialog(Dialog owner, Exception exception) {
        super(owner, (String)(owner != null ? "Error at " + owner.getTitle() : "An Error occured"));
        this.buildUI(exception);
    }

    public ErrorDialog(Frame owner, Exception exception) {
        super(owner, (String)(owner != null ? "Error at " + owner.getTitle() : "An Error occured"));
        this.buildUI(exception);
    }

    public ErrorDialog(Window owner, Exception exception) {
        super(owner, (String)(owner instanceof Dialog ? "Error at " + ((Dialog)owner).getTitle() : (owner instanceof Frame ? "Error at " + ((Frame)owner).getTitle() : "An Error occured")));
        this.buildUI(exception);
    }

    public static void show(Dialog owner, Exception exception) {
        ErrorDialog errorDialog = new ErrorDialog(owner, exception);
        errorDialog.dispose();
    }

    public static void show(Frame owner, Exception exception) {
        ErrorDialog errorDialog = new ErrorDialog(owner, exception);
        errorDialog.dispose();
    }

    public static void show(Window owner, Exception exception) {
        ErrorDialog errorDialog = new ErrorDialog(owner, exception);
        errorDialog.dispose();
    }

    public static void show(Component component, Exception exception) {
        Window owner = SwingUtilities.getWindowAncestor(component);
        ErrorDialog errorDialog = new ErrorDialog(owner, exception);
        errorDialog.dispose();
    }

    private void buildUI(Exception exception) {
        this.setModal(true);
        this.setDefaultCloseOperation(1);
        this.setLocationByPlatform(true);
        this.setLayout(new BorderLayout(6, 6));
        JButton closeButton = new JButton(this.closeAction);
        closeButton.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(closeButton);
        JToggleButton stackeTraceButton = new JToggleButton(this.traceAction);
        JButton emailButton = new JButton(this.emailAction);
        emailButton.setVisible(Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.MAIL));
        this.messageScrollPane.setBorder(new EmptyBorder(6, 6, 0, 6));
        this.traceScrollPane.setVisible(false);
        this.traceScrollPane.setBorder(new EmptyBorder(6, 6, 0, 6));
        this.messageField.setText(ExceptionUtils.getRootCauseMessage((Throwable)exception));
        this.messageField.setEditable(false);
        this.messageField.setOpaque(false);
        this.messageField.setTabSize(4);
        this.messageField.setLineWrap(true);
        this.messageField.setWrapStyleWord(true);
        this.messageField.setCaretPosition(0);
        StringBuilder builder = new StringBuilder();
        for (String trace : ExceptionUtils.getRootCauseStackTrace((Throwable)exception)) {
            builder.append(trace).append("\n");
        }
        this.traceField.setText(builder.toString());
        this.traceField.setOpaque(false);
        this.traceField.setEditable(false);
        this.traceField.setFont(Font.getFont("Monospaced"));
        this.traceField.setTabSize(2);
        this.traceField.setCaretPosition(0);
        JLabel logoLabel2 = new JLabel(H2MigrationUI.DIALOG_ERROR_64_ICON);
        logoLabel2.setIconTextGap(12);
        logoLabel2.setPreferredSize(new Dimension(96, 96));
        logoLabel2.setHorizontalAlignment(0);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 10.0, 512, 2, new Insets(2, 2, 2, 2), 0, 0);
        JPanel p1 = new JPanel(new GridBagLayout());
        constraints.fill = 0;
        constraints.anchor = 10;
        p1.add((Component)logoLabel2, constraints);
        ++constraints.gridx;
        constraints.fill = 1;
        constraints.anchor = 12;
        constraints.weightx = 10.0;
        constraints.weighty = 2.0;
        p1.add((Component)this.messageScrollPane, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.fill = 1;
        constraints.anchor = 12;
        constraints.weightx = 1.0;
        constraints.weighty = 10.0;
        constraints.gridwidth = 2;
        p1.add((Component)this.traceScrollPane, constraints);
        this.add((Component)p1, "Center");
        JPanel pl = new JPanel(new FlowLayout(3, 6, 6));
        pl.add(emailButton);
        pl.add(stackeTraceButton);
        JPanel pr = new JPanel(new FlowLayout(4, 6, 6));
        pr.add(closeButton);
        JPanel p = new JPanel(new GridLayout(1, 0, 6, 6));
        p.add(pl);
        p.add(pr);
        this.add((Component)p, "South");
        this.pack();
        this.setMaximumSize(new Dimension(640, 480));
        Logger.getLogger("").log(Level.SEVERE, null, exception);
        this.setVisible(true);
    }
}

