/*
 * Decompiled with CFR 0.152.
 */
package com.manticore.h2;

import com.manticore.h2.DriverRecord;
import com.manticore.h2.ErrorDialog;
import com.manticore.h2.H2MigrationTool;
import com.manticore.h2.MetaDataTools;
import com.manticore.h2.Recommendation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.Driver;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class H2MigrationUI
extends JFrame {
    public static final ImageIcon LIST_ADD_ICON = new ImageIcon(ClassLoader.getSystemResource("com/manticore/icons/16/list-add.png"), "Add to the list.");
    public static final ImageIcon LIST_REMOVE_ICON = new ImageIcon(ClassLoader.getSystemResource("com/manticore/icons/16/list-remove.png"), "Remove from the list.");
    public static final ImageIcon EDIT_FIND_ICON = new ImageIcon(ClassLoader.getSystemResource("com/manticore/icons/16/edit-find.png"), "Find a File.");
    public static final ImageIcon DIALOG_CANCEL_16_ICON = new ImageIcon(ClassLoader.getSystemResource("com/manticore/icons/16/stop.png"), "Cancel the Dialog.");
    public static final ImageIcon DIALOG_WARNING_16_ICON = new ImageIcon(ClassLoader.getSystemResource("com/manticore/icons/16/dialog-warning.png"), "Dialog Warning.");
    public static final ImageIcon SEARCH_16_ICON = new ImageIcon(ClassLoader.getSystemResource("com/manticore/icons/16/search.png"), "Search.");
    public static final ImageIcon MAIL_NEW_16_ICON = new ImageIcon(ClassLoader.getSystemResource("com/manticore/icons/16/mail-read.png"), "Search.");
    public static final ImageIcon DIALOG_INFORMATION_64_ICON = new ImageIcon(ClassLoader.getSystemResource("com/manticore/icons/64/dialog-information.png"), "Dialog Information.");
    public static final ImageIcon DIALOG_ERROR_64_ICON = new ImageIcon(ClassLoader.getSystemResource("com/manticore/icons/64/dialog-error.png"), "Dialog Error.");
    public static final ImageIcon DIALOG_QUESTION_64_ICON = new ImageIcon(ClassLoader.getSystemResource("com/manticore/icons/64/dialog-question.png"), "Dialog Question.");
    private static final Logger LOGGER = Logger.getLogger(H2MigrationUI.class.getName());
    private static final Font MONOSPACED_FONT = new Font("Monospaced", 0, 10);
    private final DefaultListModel<File> databaseFileModel = new DefaultListModel();
    private final JList<File> databaseFileList = new JList<File>(this.databaseFileModel);
    private final Action recoverAction = new AbstractAction("Recover"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            final int[] selectedIndices = H2MigrationUI.this.databaseFileList.getSelectedIndices();
            int result = 1;
            if (H2MigrationUI.this.databaseFileList.getModel().getSize() > 0 && selectedIndices.length == 0) {
                result = JOptionPane.showConfirmDialog(H2MigrationUI.this, "Recover ALL listed H2 Database Files?", "Recovery of the H2 Databases", 0, 3, DIALOG_QUESTION_64_ICON);
            } else if (selectedIndices.length > 0) {
                result = JOptionPane.showConfirmDialog(H2MigrationUI.this, "Recover only the " + selectedIndices.length + " selected H2 Database Files?", "Recovery of the H2 Databases", 0, 3, DIALOG_QUESTION_64_ICON);
            }
            if (result == 0) {
                final JTextArea textArea = new JTextArea(24, 72);
                textArea.setFont(MONOSPACED_FONT);
                SwingWorker<List<File>, Map.Entry<File, String>> worker = new SwingWorker<List<File>, Map.Entry<File, String>>(){

                    @Override
                    protected List<File> doInBackground() throws Exception {
                        H2MigrationTool tool = new H2MigrationTool();
                        H2MigrationTool.readDriverRecords();
                        DriverRecord from = H2MigrationUI.this.fromVersionList.getSelectedValue();
                        ArrayList<File> databaseFiles = new ArrayList<File>();
                        ArrayList<File> failedDatabaseFiles = new ArrayList<File>();
                        if (selectedIndices.length > 0) {
                            for (int i : selectedIndices) {
                                databaseFiles.add(H2MigrationUI.this.databaseFileModel.get(i));
                            }
                        } else {
                            databaseFiles.addAll(Collections.list(H2MigrationUI.this.databaseFileModel.elements()));
                        }
                        Object object = databaseFiles.iterator();
                        while (object.hasNext()) {
                            File f = (File)object.next();
                            try {
                                H2MigrationTool.ScriptResult result = tool.writeRecoveryScript(from, f.getParent(), f.getName());
                                this.publish(new AbstractMap.SimpleEntry<File, String>(f, result.scriptFileName));
                            }
                            catch (Exception ex) {
                                LOGGER.log(Level.WARNING, "Failed to recover " + f.getAbsolutePath(), ex);
                                failedDatabaseFiles.add(f);
                            }
                        }
                        return failedDatabaseFiles;
                    }

                    @Override
                    protected void process(List<Map.Entry<File, String>> entries) {
                        for (Map.Entry<File, String> e : entries) {
                            textArea.append(e.getKey().getAbsolutePath() + " \u2192 " + e.getValue() + "\n");
                            if (Desktop.isDesktopSupported()) {
                                Desktop desktop = Desktop.getDesktop();
                                if (desktop.isSupported(Desktop.Action.OPEN)) {
                                    try {
                                        desktop.open(e.getKey());
                                    }
                                    catch (IOException ex) {
                                        LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
                                    }
                                    continue;
                                }
                                if (desktop.isSupported(Desktop.Action.BROWSE_FILE_DIR)) {
                                    desktop.browseFileDirectory(e.getKey());
                                    continue;
                                }
                                if (!desktop.isSupported(Desktop.Action.BROWSE)) continue;
                                try {
                                    desktop.browse(e.getKey().toURI());
                                }
                                catch (IOException ex) {
                                    LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
                                }
                                continue;
                            }
                            LOGGER.warning("Desktop Actions are not supported.");
                            JFileChooser chooser = new JFileChooser(e.getKey());
                            chooser.setDialogType(1);
                            chooser.setSelectedFile(e.getKey());
                            chooser.setFileSelectionMode(0);
                            chooser.showSaveDialog(H2MigrationUI.this);
                        }
                    }

                    @Override
                    protected void done() {
                        try {
                            List files = (List)this.get();
                            int n = files.size();
                            if (n > 0) {
                                int[] selectedIndices2 = new int[n];
                                textArea.append("\n" + n + " have not been recovered:\n");
                                int i = 0;
                                for (File f : files) {
                                    textArea.append(f.getAbsolutePath() + "\n");
                                    selectedIndices2[i++] = H2MigrationUI.this.databaseFileModel.indexOf(f);
                                }
                                H2MigrationUI.this.databaseFileList.setSelectedIndices(selectedIndices2);
                            } else {
                                textArea.append("\nReady without errors.");
                            }
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(H2MigrationUI.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (ExecutionException ex) {
                            Logger.getLogger(H2MigrationUI.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                };
                H2MigrationUI.executeAndWait(worker, H2MigrationUI.this, textArea);
            }
        }
    };
    private final JButton recoverButton = new JButton(this.recoverAction);
    private final Action migrateAction = new AbstractAction("Migrate"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            final int[] selectedIndices = H2MigrationUI.this.databaseFileList.getSelectedIndices();
            int result = 1;
            if (H2MigrationUI.this.databaseFileList.getModel().getSize() > 0 && selectedIndices.length == 0) {
                result = JOptionPane.showConfirmDialog(H2MigrationUI.this, "Migrate ALL listed H2 Database Files?", "Migration of the H2 Databases", 0, 3, DIALOG_QUESTION_64_ICON);
            } else if (selectedIndices.length > 0) {
                result = JOptionPane.showConfirmDialog(H2MigrationUI.this, "Migrate only the " + selectedIndices.length + " selected H2 Database Files?", "Migration of the H2 Databases", 0, 3, DIALOG_QUESTION_64_ICON);
            }
            if (result == 0) {
                final JTextArea textArea = new JTextArea(24, 72);
                textArea.setFont(MONOSPACED_FONT);
                SwingWorker<List<File>, Map.Entry<File, String>> worker = new SwingWorker<List<File>, Map.Entry<File, String>>(){

                    @Override
                    protected List<File> doInBackground() throws Exception {
                        String connectionParameters = H2MigrationUI.this.connectionParameterField.getText();
                        Properties properties = new Properties();
                        properties.setProperty("user", H2MigrationUI.this.usernameField.getText());
                        properties.setProperty("password", H2MigrationUI.this.passwordField.getText());
                        H2MigrationTool tool = new H2MigrationTool();
                        H2MigrationTool.readDriverRecords();
                        DriverRecord from = H2MigrationUI.this.fromVersionList.getSelectedValue();
                        DriverRecord to = H2MigrationUI.this.toVersionList.getSelectedValue();
                        ArrayList<File> databaseFiles = new ArrayList<File>();
                        ArrayList<File> failedDatabaseFiles = new ArrayList<File>();
                        if (selectedIndices.length > 0) {
                            for (int i : selectedIndices) {
                                databaseFiles.add(H2MigrationUI.this.databaseFileModel.get(i));
                            }
                        } else {
                            databaseFiles.addAll(Collections.list(H2MigrationUI.this.databaseFileModel.elements()));
                        }
                        Object object = databaseFiles.iterator();
                        while (object.hasNext()) {
                            File f = (File)object.next();
                            try {
                                Object compression;
                                Object upgradeOptions;
                                String versionFrom = from != null ? from.getVersion() : "";
                                String versionTo = to != null ? to.getVersion() : "";
                                String username = H2MigrationUI.this.usernameField.getText();
                                String password = H2MigrationUI.this.passwordField.getText();
                                Object object2 = upgradeOptions = H2MigrationUI.this.quirksModeBox.isSelected() ? "QUIRKS_MODE" : "";
                                if (H2MigrationUI.this.varbinaryBox.isSelected()) {
                                    upgradeOptions = (String)upgradeOptions + (((String)upgradeOptions).isEmpty() ? "VARIABLE_BINARY" : " VARIABLE_BINARY");
                                }
                                if ((compression = (String)H2MigrationUI.this.compressionBox.getSelectedItem()) != null && ((String)compression).length() > 0) {
                                    compression = "COMPRESSION " + (String)compression;
                                }
                                boolean overwrite = H2MigrationUI.this.overwriteBox.isSelected();
                                H2MigrationTool.ScriptResult result = tool.migrate(versionFrom, versionTo, f.getAbsolutePath(), username, password, "", (String)compression, (String)upgradeOptions, overwrite, overwrite, connectionParameters);
                                this.publish(new AbstractMap.SimpleEntry<File, String>(f, result.scriptFileName));
                            }
                            catch (Exception ex) {
                                LOGGER.log(Level.WARNING, "Failed to migrate " + f.getAbsolutePath(), ex);
                                failedDatabaseFiles.add(f);
                            }
                        }
                        return failedDatabaseFiles;
                    }

                    @Override
                    protected void process(List<Map.Entry<File, String>> entries) {
                        for (Map.Entry<File, String> e : entries) {
                            textArea.append(e.getKey().getAbsolutePath() + "\n \ud83e\udc32 " + e.getValue() + "\n");
                            if (Desktop.isDesktopSupported()) {
                                Desktop desktop = Desktop.getDesktop();
                                if (desktop.isSupported(Desktop.Action.OPEN)) {
                                    try {
                                        desktop.open(e.getKey());
                                    }
                                    catch (IOException ex) {
                                        LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
                                    }
                                    continue;
                                }
                                if (desktop.isSupported(Desktop.Action.BROWSE_FILE_DIR)) {
                                    desktop.browseFileDirectory(e.getKey());
                                    continue;
                                }
                                if (!desktop.isSupported(Desktop.Action.BROWSE)) continue;
                                try {
                                    desktop.browse(e.getKey().toURI());
                                }
                                catch (IOException ex) {
                                    LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
                                }
                                continue;
                            }
                            LOGGER.warning("Desktop Actions are not supported.");
                            JFileChooser chooser = new JFileChooser(e.getKey());
                            chooser.setDialogType(1);
                            chooser.setSelectedFile(e.getKey());
                            chooser.setFileSelectionMode(0);
                            chooser.showSaveDialog(H2MigrationUI.this);
                        }
                    }

                    @Override
                    protected void done() {
                        try {
                            List files = (List)this.get();
                            int n = files.size();
                            if (n > 0) {
                                int[] selectedIndices2 = new int[n];
                                textArea.append("\n" + n + " have not been migrated:\n");
                                int i = 0;
                                for (File f : files) {
                                    textArea.append(f.getAbsolutePath() + "\n");
                                    selectedIndices2[i++] = H2MigrationUI.this.databaseFileModel.indexOf(f);
                                }
                                H2MigrationUI.this.databaseFileList.setSelectedIndices(selectedIndices2);
                            } else {
                                textArea.append("\nReady without errors.");
                            }
                        }
                        catch (InterruptedException | ExecutionException ex) {
                            LOGGER.log(Level.SEVERE, null, ex);
                        }
                    }
                };
                H2MigrationUI.executeAndWait(worker, H2MigrationUI.this, textArea);
            }
        }
    };
    private final JButton migrateButton = new JButton(this.migrateAction);
    private final Action removeDatabaseFileAction = new AbstractAction("Remove Database File", LIST_REMOVE_ICON){

        @Override
        public void actionPerformed(ActionEvent ae) {
            int[] selectedIndices = H2MigrationUI.this.databaseFileList.getSelectedIndices();
            for (int i = selectedIndices.length - 1; i >= 0; --i) {
                H2MigrationUI.this.databaseFileModel.remove(selectedIndices[i]);
            }
        }
    };
    private final Action verifyDatabaseFileAction = new AbstractAction("Verify Database File", DIALOG_WARNING_16_ICON){

        @Override
        public void actionPerformed(ActionEvent ae) {
            final int[] selectedIndices = H2MigrationUI.this.databaseFileList.getSelectedIndices();
            int result = 1;
            if (H2MigrationUI.this.databaseFileList.getModel().getSize() > 0 && selectedIndices.length == 0) {
                result = JOptionPane.showConfirmDialog(H2MigrationUI.this, "Verify ALL listed H2 Database Files?", "Verification of the H2 Databases", 0, 3, DIALOG_QUESTION_64_ICON);
            } else if (selectedIndices.length > 0) {
                result = JOptionPane.showConfirmDialog(H2MigrationUI.this, "Verify only the " + selectedIndices.length + " selected H2 Database Files?", "Verification of the H2 Databases", 0, 3, DIALOG_QUESTION_64_ICON);
            }
            if (result == 0) {
                final TreeMap recommendations = new TreeMap();
                SwingWorker worker = new SwingWorker(){

                    protected Object doInBackground() throws Exception {
                        Properties properties = new Properties();
                        properties.setProperty("user", H2MigrationUI.this.usernameField.getText());
                        properties.setProperty("password", H2MigrationUI.this.passwordField.getText());
                        DriverRecord driverRecord = H2MigrationUI.this.fromVersionList.getSelectedValue();
                        Driver driver = H2MigrationTool.loadDriver("", driverRecord.getVersion());
                        ArrayList<File> databaseFiles = new ArrayList<File>();
                        if (selectedIndices.length > 0) {
                            for (int i : selectedIndices) {
                                databaseFiles.add(H2MigrationUI.this.databaseFileModel.get(i));
                            }
                        } else {
                            databaseFiles.addAll(Collections.list(H2MigrationUI.this.databaseFileModel.elements()));
                        }
                        Object object = databaseFiles.iterator();
                        while (object.hasNext()) {
                            File f = (File)object.next();
                            String fileName = f.getAbsolutePath();
                            if (fileName.toLowerCase().endsWith(".mv.db")) {
                                fileName = fileName.substring(0, fileName.length() - ".mv.db".length());
                            }
                            Connection con = driver.connect("jdbc:h2:" + fileName, properties);
                            try {
                                Collection<Recommendation> r = MetaDataTools.verifyDecimalPrecision(con);
                                if (r.isEmpty()) continue;
                                if (!recommendations.containsKey(f)) {
                                    recommendations.put(f, r);
                                    continue;
                                }
                                ((Collection)recommendations.get(f)).addAll(r);
                            }
                            finally {
                                if (con == null) continue;
                                con.close();
                            }
                        }
                        return recommendations;
                    }

                    @Override
                    protected void done() {
                        JTextArea textArea = new JTextArea(24, 72);
                        textArea.setFont(MONOSPACED_FONT);
                        for (Map.Entry e : recommendations.entrySet()) {
                            textArea.append("------------------------------------------------------------------------------------------------\n");
                            textArea.append("-- ");
                            textArea.append(((File)e.getKey()).getAbsolutePath());
                            textArea.append("\n\n");
                            for (Recommendation r : (Collection)e.getValue()) {
                                textArea.append("-- " + r.issue + "\n");
                                textArea.append(r.recommendation + "\n");
                            }
                        }
                        textArea.setCaretPosition(0);
                        JOptionPane.showMessageDialog(H2MigrationUI.this, new JScrollPane(textArea));
                    }
                };
                H2MigrationUI.executeAndWait(worker, H2MigrationUI.this);
            }
        }
    };
    private final JTextField connectionParameterField = new JTextField(";MODE=Oracle;CACHE_SIZE=8192", 22);
    private final JTextField usernameField = new JTextField("SA", 8);
    private final JTextField passwordField = new JTextField("", 8);
    private final DefaultListModel<DriverRecord> listModel = new DefaultListModel();
    private final JList<DriverRecord> fromVersionList = new JList();
    private final JList<DriverRecord> toVersionList = new JList();
    private final JComboBox<String> compressionBox = new JComboBox<String>(new String[]{"", "ZIP", "GZIP"});
    private final JComboBox<String> repairModeBox = new JComboBox<String>(new String[]{"", "REPAIR", "WORK-AROUND"});
    private final JCheckBox varbinaryBox = new JCheckBox("Convert BINARY to VARBINARY", false);
    private final JCheckBox quirksModeBox = new JCheckBox("Quirks Mode", true);
    private final JCheckBox overwriteBox = new JCheckBox("Overwrite", false);
    private final Action addDatabaseFileAction = new AbstractAction("Add Database File", LIST_ADD_ICON){

        @Override
        public void actionPerformed(ActionEvent ae) {
            ArrayList exceptions = new ArrayList();
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.addChoosableFileFilter(H2MigrationTool.H2_DATABASE_FILE_FILTER);
            fileChooser.addChoosableFileFilter(H2MigrationTool.SQL_SCRIPT_FILE_FILTER);
            fileChooser.setDialogTitle("Select the H2 Database Files and Directories");
            fileChooser.setFileSelectionMode(2);
            fileChooser.setFileHidingEnabled(false);
            fileChooser.setDialogType(0);
            fileChooser.setSelectedFile(H2MigrationTool.getAbsoluteFile("~"));
            int result = fileChooser.showOpenDialog(H2MigrationUI.this);
            if (0 == result) {
                File[] selectedFiles = fileChooser.getSelectedFiles();
                if (selectedFiles.length == 0) {
                    final File selectedFile = fileChooser.getSelectedFile();
                    if (selectedFile.isDirectory()) {
                        try {
                            SwingWorker<Collection<Path>, Path> worker = new SwingWorker<Collection<Path>, Path>(){

                                @Override
                                protected Collection<Path> doInBackground() throws Exception {
                                    return H2MigrationTool.findH2Databases(selectedFile.getAbsolutePath(), new FileFilter[0]);
                                }
                            };
                            H2MigrationUI.executeAndWait(worker, H2MigrationUI.this);
                            Collection h2DatabasePaths = (Collection)worker.get();
                            for (Path p : h2DatabasePaths) {
                                H2MigrationUI.this.databaseFileModel.addElement(p.toFile());
                            }
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(H2MigrationUI.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (ExecutionException ex) {
                            Logger.getLogger(H2MigrationUI.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    } else {
                        LOGGER.info(selectedFile.getAbsolutePath());
                        H2MigrationUI.this.databaseFileModel.addElement(selectedFile);
                    }
                } else {
                    for (File f : selectedFiles) {
                        LOGGER.info(f.getAbsolutePath());
                        H2MigrationUI.this.databaseFileModel.addElement(f);
                    }
                }
                if (!exceptions.isEmpty()) {
                    Exception ex = new Exception("Could not read all files.");
                    for (Exception ex1 : exceptions) {
                        ex.addSuppressed(ex1);
                    }
                    LOGGER.log(Level.WARNING, "Failed to read some files.", ex);
                }
            }
        }
    };
    private final Action addDatabaseDriversAction = new AbstractAction("Add H2 Drivers", LIST_ADD_ICON){

        @Override
        public void actionPerformed(ActionEvent ae) {
            ArrayList<Exception> exceptions = new ArrayList<Exception>();
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Select the H2 Database Files and Directories");
            fileChooser.setFileSelectionMode(2);
            fileChooser.setFileHidingEnabled(false);
            fileChooser.setDialogType(0);
            fileChooser.setSelectedFile(H2MigrationTool.getAbsoluteFile("~/.m2/repository/com/h2database/h2"));
            int result = fileChooser.showOpenDialog(H2MigrationUI.this);
            if (0 == result) {
                File[] selectedFiles = fileChooser.getSelectedFiles();
                if (selectedFiles.length == 0) {
                    final File selectedFile = fileChooser.getSelectedFile();
                    if (selectedFile.isDirectory()) {
                        try {
                            SwingWorker<Collection<Path>, Path> worker = new SwingWorker<Collection<Path>, Path>(){

                                @Override
                                protected Collection<Path> doInBackground() throws Exception {
                                    return H2MigrationTool.findH2Drivers(selectedFile.getAbsolutePath());
                                }
                            };
                            H2MigrationUI.executeAndWait(worker, H2MigrationUI.this);
                            Collection h2DriverPaths = (Collection)worker.get();
                            for (Path p : h2DriverPaths) {
                                try {
                                    H2MigrationTool.readDriverRecord(p);
                                }
                                catch (Exception ex) {
                                    exceptions.add(ex);
                                }
                            }
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.SEVERE, null, ex);
                        }
                    } else {
                        LOGGER.info(selectedFile.getAbsolutePath());
                        try {
                            H2MigrationTool.readDriverRecord(selectedFile.toPath());
                        }
                        catch (Exception ex) {
                            exceptions.add(ex);
                        }
                    }
                } else {
                    for (File f : selectedFiles) {
                        LOGGER.info(f.getAbsolutePath());
                        try {
                            H2MigrationTool.readDriverRecord(f.toPath());
                        }
                        catch (Exception ex) {
                            exceptions.add(ex);
                        }
                    }
                }
                if (!exceptions.isEmpty()) {
                    Exception ex = new Exception("Could not read all Driver files.");
                    for (Exception ex1 : exceptions) {
                        ex.addSuppressed(ex1);
                    }
                    LOGGER.log(Level.WARNING, "Failed to read some files.", ex);
                }
            }
            H2MigrationUI.this.listModel.clear();
            H2MigrationUI.this.listModel.addAll(H2MigrationTool.getDriverRecords());
        }
    };
    private final Action helpAction = new AbstractAction("Help"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            ErrorDialog.show(H2MigrationUI.this, (Exception)new UnsupportedOperationException("Not supported yet."));
        }
    };
    private final Action exitAction = new AbstractAction("Exit"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            H2MigrationUI.this.setVisible(false);
        }
    };
    private final JButton helpButton = new JButton(this.helpAction);
    private final JButton exitButton = new JButton(this.exitAction);

    public H2MigrationUI() {
        super("H2 Database Migration Tool");
    }

    public static JDialog getWorkerWaitDialog(Component component) {
        Window windowAncestor = SwingUtilities.getWindowAncestor(component);
        JOptionPane p = new JOptionPane("Please wait while the data are collected in the background.\nThis will take a few minutes...", 1, -1, DIALOG_INFORMATION_64_ICON);
        JDialog dialog = new JDialog(windowAncestor, "Operation in progress", Dialog.ModalityType.APPLICATION_MODAL);
        dialog.setLocationByPlatform(true);
        dialog.setAlwaysOnTop(true);
        dialog.setCursor(Cursor.getPredefinedCursor(3));
        dialog.add(p);
        dialog.pack();
        return dialog;
    }

    public static void executeAndWait(SwingWorker<?, ?> worker, JDialog dialog) {
        worker.addPropertyChangeListener(new SwingWorkerCompletionWaiter(dialog));
        worker.execute();
        dialog.setVisible(true);
    }

    public static void executeAndWait(final SwingWorker<?, ?> worker, Component component, JTextArea textArea) {
        Window windowAncestor = SwingUtilities.getWindowAncestor(component);
        final JDialog dialog = new JDialog(windowAncestor, "Operation in progress", Dialog.ModalityType.APPLICATION_MODAL);
        final AbstractAction closeAction = new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (worker.isDone()) {
                    dialog.setCursor(Cursor.getPredefinedCursor(0));
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            }
        };
        closeAction.setEnabled(false);
        final AbstractAction cancelAction = new AbstractAction("Cancel", DIALOG_CANCEL_16_ICON){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!worker.isDone()) {
                    worker.cancel(true);
                }
                dialog.setCursor(Cursor.getPredefinedCursor(0));
                dialog.setVisible(false);
                dialog.dispose();
            }
        };
        cancelAction.setEnabled(true);
        JLabel iconLabel = new JLabel(DIALOG_INFORMATION_64_ICON);
        iconLabel.setVerticalAlignment(1);
        iconLabel.setBorder(new EmptyBorder(12, 12, 12, 12));
        JPanel buttonPanel = new JPanel(new FlowLayout(4, 6, 2));
        buttonPanel.add(new JButton(cancelAction));
        buttonPanel.add(new JButton(closeAction));
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setPreferredSize(new Dimension(320, 180));
        scrollPane.setWheelScrollingEnabled(true);
        scrollPane.setFocusable(false);
        textArea.setEditable(false);
        dialog.setLayout(new BorderLayout(6, 6));
        dialog.add((Component)iconLabel, "West");
        dialog.add(scrollPane);
        dialog.add((Component)buttonPanel, "South");
        dialog.setLocationByPlatform(true);
        dialog.setAlwaysOnTop(true);
        dialog.setCursor(Cursor.getPredefinedCursor(3));
        dialog.pack();
        worker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if ("state".equals(event.getPropertyName()) && SwingWorker.StateValue.DONE == event.getNewValue()) {
                    closeAction.setEnabled(true);
                    cancelAction.setEnabled(false);
                    dialog.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        worker.execute();
        dialog.setVisible(true);
    }

    public static void executeAndWait(SwingWorker<?, ?> worker, Component component) {
        Window windowAncestor = SwingUtilities.getWindowAncestor(component);
        JOptionPane p = new JOptionPane("Please wait while the data are collected in the background.\nThis will take a few minutes...", 1, -1, DIALOG_INFORMATION_64_ICON);
        JDialog dialog = new JDialog(windowAncestor, "Operation in progress", Dialog.ModalityType.APPLICATION_MODAL);
        dialog.setLocationByPlatform(true);
        dialog.setAlwaysOnTop(true);
        dialog.setCursor(Cursor.getPredefinedCursor(3));
        dialog.add(p);
        dialog.pack();
        worker.addPropertyChangeListener(new SwingWorkerCompletionWaiter(dialog));
        worker.execute();
        dialog.setVisible(true);
    }

    private final String getLabel(String label, int annotation) {
        switch (annotation) {
            case 1: {
                return "<html><u>" + label + "</u><font color='red'>*</font>:</html>";
            }
            case 2: {
                return "<html>" + label + "<font color='blue'>*</font>:</html>";
            }
        }
        return label + ":";
    }

    public void buildUI(boolean visible) {
        this.setLayout(new BorderLayout(6, 6));
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                LOGGER.info("Exiting the VM when Frame as been closed.");
                System.exit(0);
            }
        });
        Color selectedTextBackGround = UIManager.getLookAndFeel().getDefaults().getColor("Table[Enabled+Selected].textBackground");
        Color selectedTextForeGround = UIManager.getLookAndFeel().getDefaults().getColor("Table[Enabled+Selected].textForeground");
        String headerText = "<html><p>Migrate existing H2 databases to a newer H2 Version:</p><ol><li>Select the <b>H2 Database Files</b> (single H2 DB file or a directory)</li><li>Select the  <b>Version FROM</b> and <b>Version TO</b></li><li>Start <b>Migrate</b></li></ol></html";
        JLabel headerTextArea = new JLabel(headerText);
        headerTextArea.setBackground(selectedTextBackGround);
        headerTextArea.setForeground(selectedTextForeGround);
        headerTextArea.setOpaque(true);
        headerTextArea.setBorder(new EmptyBorder(6, 6, 6, 6));
        this.add((Component)headerTextArea, "North");
        this.databaseFileList.setPrototypeCellValue(new File(String.copyValueOf(new char[255])));
        this.listModel.clear();
        this.listModel.addAll(H2MigrationTool.getDriverRecords());
        this.fromVersionList.setModel(this.listModel);
        this.fromVersionList.setSelectedValue(H2MigrationTool.getDriverRecord(H2MigrationTool.getDriverRecords(), 1, 4), true);
        this.toVersionList.setModel(this.listModel);
        this.toVersionList.setSelectedValue(H2MigrationTool.getDriverRecord(H2MigrationTool.getDriverRecords(), 2, 0), true);
        this.compressionBox.setSelectedIndex(1);
        this.migrateButton.setDefaultCapable(true);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 10.0, 512, 2, new Insets(6, 6, 0, 0), 0, 0);
        JPanel centerNorthPanel = new JPanel(new GridBagLayout());
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.gridwidth = 1;
        constraints.fill = 2;
        constraints.anchor = 512;
        constraints.weighty = 1.0;
        JLabel databaseFileLabel = new JLabel(this.getLabel("Database Files", 1));
        databaseFileLabel.setLabelFor(this.databaseFileList);
        databaseFileLabel.setHorizontalAlignment(11);
        centerNorthPanel.add((Component)databaseFileLabel, constraints);
        ++constraints.gridx;
        constraints.weightx = 5.0;
        constraints.gridwidth = 3;
        constraints.gridheight = 2;
        constraints.fill = 1;
        centerNorthPanel.add((Component)new JScrollPane(this.databaseFileList), constraints);
        constraints.gridx += 3;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.insets.left = 0;
        constraints.anchor = 23;
        JToolBar databaseFileActionsBar = new JToolBar("Database File Actions", 1);
        databaseFileActionsBar.setBorderPainted(false);
        databaseFileActionsBar.setFloatable(false);
        databaseFileActionsBar.add(this.addDatabaseFileAction).setHideActionText(true);
        databaseFileActionsBar.add(this.removeDatabaseFileAction).setHideActionText(true);
        databaseFileActionsBar.add(this.verifyDatabaseFileAction).setHideActionText(true);
        centerNorthPanel.add((Component)databaseFileActionsBar, constraints);
        JLabel scriptLabel = new JLabel(this.getLabel("SQL Script Files", 2));
        scriptLabel.setHorizontalAlignment(11);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.fill = 2;
        constraints.anchor = 12;
        constraints.weighty = 100.0;
        databaseFileLabel.setHorizontalAlignment(11);
        centerNorthPanel.add((Component)scriptLabel, constraints);
        constraints.insets.left = 6;
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 512;
        JLabel connectionParameterLabel = new JLabel(this.getLabel("Con. Param.", 2));
        connectionParameterLabel.setLabelFor(this.connectionParameterField);
        connectionParameterLabel.setHorizontalAlignment(11);
        centerNorthPanel.add((Component)connectionParameterLabel, constraints);
        ++constraints.gridx;
        constraints.gridwidth = 3;
        centerNorthPanel.add((Component)this.connectionParameterField, constraints);
        constraints.insets.left = 6;
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.weighty = 1.0;
        constraints.gridwidth = 1;
        constraints.fill = 2;
        constraints.anchor = 512;
        JLabel usernameLabel = new JLabel(this.getLabel("Username", 2));
        usernameLabel.setLabelFor(this.usernameField);
        usernameLabel.setHorizontalAlignment(11);
        centerNorthPanel.add((Component)usernameLabel, constraints);
        ++constraints.gridx;
        centerNorthPanel.add((Component)this.usernameField, constraints);
        ++constraints.gridx;
        JLabel passwordLabel = new JLabel(this.getLabel("Password", 2));
        passwordLabel.setLabelFor(this.passwordField);
        passwordLabel.setHorizontalAlignment(11);
        centerNorthPanel.add((Component)passwordLabel, constraints);
        ++constraints.gridx;
        centerNorthPanel.add((Component)this.passwordField, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.weightx = 3.0;
        constraints.fill = 2;
        constraints.anchor = 512;
        JLabel versionListLabel = new JLabel(this.getLabel("Versions", 2));
        versionListLabel.setHorizontalAlignment(11);
        centerNorthPanel.add((Component)versionListLabel, constraints);
        JToolBar databaseDriverActionsBar = new JToolBar("Database Driver Actions", 1);
        databaseDriverActionsBar.setBorderPainted(false);
        databaseDriverActionsBar.setFloatable(false);
        databaseDriverActionsBar.add(this.addDatabaseDriversAction).setHideActionText(true);
        JScrollPane fromVersionListScrollPane = new JScrollPane(this.fromVersionList);
        JLabel fromVersionPaneLabel = new JLabel("From H2 Version");
        fromVersionPaneLabel.setHorizontalAlignment(0);
        fromVersionPaneLabel.setFont(fromVersionPaneLabel.getFont().deriveFont(1, 9.0f));
        JPanel fromVersionListPane = new JPanel(new BorderLayout());
        fromVersionListPane.add((Component)fromVersionPaneLabel, "North");
        fromVersionListPane.add((Component)fromVersionListScrollPane, "Center");
        JScrollPane toVersionListScrollPane = new JScrollPane(this.toVersionList);
        JLabel toVersionPaneLabel = new JLabel("To H2 Version");
        toVersionPaneLabel.setHorizontalAlignment(0);
        toVersionPaneLabel.setFont(toVersionPaneLabel.getFont().deriveFont(1, 9.0f));
        JPanel toVersionListPane = new JPanel(new BorderLayout());
        toVersionListPane.add((Component)toVersionPaneLabel, "North");
        toVersionListPane.add((Component)toVersionListScrollPane, "Center");
        JPanel centerCenterPanel = new JPanel(new GridLayout(1, 0, 6, 6));
        centerCenterPanel.add(fromVersionListPane);
        centerCenterPanel.add(toVersionListPane);
        ++constraints.gridx;
        constraints.weightx = 10.0;
        constraints.gridwidth = 3;
        constraints.fill = 1;
        centerNorthPanel.add((Component)centerCenterPanel, constraints);
        constraints.gridx += 3;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.insets.left = 0;
        constraints.anchor = 23;
        centerNorthPanel.add((Component)databaseDriverActionsBar, constraints);
        this.add((Component)centerNorthPanel, "Center");
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.gridwidth = 1;
        constraints.fill = 2;
        constraints.anchor = 512;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        JLabel compressionLabel = new JLabel(this.getLabel("Compression", 0));
        compressionLabel.setLabelFor(this.compressionBox);
        compressionLabel.setHorizontalAlignment(11);
        centerNorthPanel.add((Component)compressionLabel, constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        constraints.gridwidth = 2;
        constraints.fill = 0;
        centerNorthPanel.add(this.compressionBox, constraints);
        JLabel checkBoxPaneLabel = new JLabel("Other Options");
        checkBoxPaneLabel.setHorizontalAlignment(0);
        checkBoxPaneLabel.setFont(checkBoxPaneLabel.getFont().deriveFont(1, 9.0f));
        JPanel checkBoxPanel = new JPanel(new GridLayout(0, 1, 6, 6));
        checkBoxPanel.add(checkBoxPaneLabel);
        checkBoxPanel.add(this.varbinaryBox);
        checkBoxPanel.add(this.quirksModeBox);
        checkBoxPanel.add(this.overwriteBox);
        ++constraints.gridx;
        constraints.gridheight = 4;
        constraints.gridwidth = 2;
        centerNorthPanel.add((Component)checkBoxPanel, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.gridwidth = 1;
        constraints.fill = 2;
        constraints.anchor = 512;
        constraints.weightx = 1.0;
        JLabel repairModeLabel = new JLabel(this.getLabel("Repair Mode", 0));
        repairModeLabel.setLabelFor(this.repairModeBox);
        repairModeLabel.setHorizontalAlignment(11);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        constraints.fill = 0;
        JPanel southEastPanel = new JPanel(new FlowLayout(3, 6, 2));
        southEastPanel.add(this.helpButton);
        JPanel southWestPanel = new JPanel(new FlowLayout(4, 6, 2));
        southWestPanel.add(this.recoverButton);
        southWestPanel.add(this.migrateButton);
        southWestPanel.add(this.exitButton);
        JPanel southPanel = new JPanel(new GridLayout(1, 2));
        southPanel.add(southEastPanel);
        southPanel.add(southWestPanel);
        this.add((Component)southPanel, "South");
        this.setPreferredSize(new Dimension(480, 720));
        this.pack();
        this.setMinimumSize(this.getSize());
        this.setVisible(visible);
    }

    private static class SwingWorkerCompletionWaiter
    implements PropertyChangeListener {
        private final JDialog dialog;

        public SwingWorkerCompletionWaiter(JDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("state".equals(event.getPropertyName()) && SwingWorker.StateValue.DONE == event.getNewValue()) {
                this.dialog.setCursor(Cursor.getDefaultCursor());
                this.dialog.setVisible(false);
                this.dialog.dispose();
            }
        }
    }
}

