/*
 * Decompiled with CFR 0.152.
 */
package com.manticore.h2;

import com.manticore.h2.Catalog;
import com.manticore.h2.Schema;
import com.manticore.h2.Table;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class MetaData {
    private final TreeMap<String, Catalog> catalogs = new TreeMap();
    private final DatabaseMetaData metaData;

    public MetaData(Connection con) throws SQLException {
        this.metaData = con.getMetaData();
    }

    public void build() throws SQLException {
        for (Catalog catalog : Catalog.getCatalogs(this.metaData)) {
            this.put(catalog);
        }
        for (Schema schema : Schema.getSchemas(this.metaData)) {
            this.put(schema);
        }
        for (Table table : Table.getTables(this.metaData)) {
            this.put(table);
            table.getColumns(this.metaData);
            if (!table.tableType.equals("TABLE") && !table.tableType.equals("SYSTEM TABLE")) continue;
            table.getIndices(this.metaData, true);
            table.getPrimaryKey(this.metaData);
        }
    }

    public Catalog put(Catalog catalog) {
        return this.catalogs.put(catalog.tableCatalog.toUpperCase(), catalog);
    }

    public Map<String, Catalog> getCatalogs() {
        return Collections.unmodifiableMap(this.catalogs);
    }

    public Schema put(Schema schema) {
        Catalog catalog = this.catalogs.get(schema.tableCatalog.toUpperCase());
        return catalog.put(schema);
    }

    public Table put(Table table) {
        Catalog catalog = this.catalogs.get(table.tableCatalog.toUpperCase());
        Schema schema = catalog.get(table.tableSchema.toUpperCase());
        return schema.put(table);
    }
}

