/*
 * Decompiled with CFR 0.152.
 */
package com.manticore.h2;

import com.manticore.h2.Catalog;
import com.manticore.h2.Column;
import com.manticore.h2.MetaData;
import com.manticore.h2.Recommendation;
import com.manticore.h2.Schema;
import com.manticore.h2.Table;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Logger;

public class MetaDataTools {
    public static final Logger LOGGER = Logger.getLogger(MetaDataTools.class.getName());
    public static final String H2_VERSION = "2.0.201";
    public static final String DB_FILE_URI_STR = "file:/home/are/Downloads/cmb/.manticore/ifrsbox_202101";

    public static Collection<Recommendation> verifyDecimalPrecision(Connection con) throws SQLException {
        ArrayList<Recommendation> recommendations = new ArrayList<Recommendation>();
        MetaData meta = new MetaData(con);
        meta.build();
        for (Catalog cat : meta.getCatalogs().values()) {
            for (Schema schema : cat.schemas.values()) {
                for (Table table : schema.tables.values()) {
                    for (Column column : table.columns) {
                        if (!Set.of(Integer.valueOf(3), Integer.valueOf(2)).contains(column.dataType) || column.columnSize <= 128 && column.decimalDigits <= 128) continue;
                        LOGGER.warning("Found suspicious column: " + column);
                        int precision = 0;
                        int scale = 0;
                        String sqlStr = "SELECT \"" + column.columnName + "\" FROM \"" + column.tableSchema + "\".\"" + column.tableName + "\"";
                        Statement st = con.createStatement();
                        try {
                            ResultSet rs = st.executeQuery(sqlStr);
                            try {
                                while (rs.next()) {
                                    BigDecimal d = rs.getBigDecimal(1);
                                    precision = Math.max(precision, d.precision());
                                    scale = Math.max(scale, d.scale());
                                }
                                LOGGER.fine("Suggest: " + column.columnName + "\t" + column.typeName + "(" + precision + ", " + scale + ")");
                                String issue = "Invalid Decimal Precision/Scale: " + column.tableSchema + "." + column.tableName + "." + column.columnName + "    " + column.typeName + " (" + column.columnSize + "." + column.decimalDigits + ")";
                                String alterStatementStr = "ALTER TABLE " + column.tableSchema + "." + column.tableName + "\nMODIFY COLUMN " + column.columnName + " " + column.typeName + "(" + precision + "," + scale + ");\n";
                                Recommendation recommendation = new Recommendation(issue, alterStatementStr);
                                recommendations.add(recommendation);
                            }
                            finally {
                                if (rs == null) continue;
                                rs.close();
                            }
                        }
                        finally {
                            if (st == null) continue;
                            st.close();
                        }
                    }
                }
            }
        }
        return recommendations;
    }
}

