/*
 * Decompiled with CFR 0.152.
 */
package com.manticore.h2;

import com.manticore.h2.Table;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Logger;

public class Schema
implements Comparable<Schema> {
    public static final Logger LOGGER = Logger.getLogger(Schema.class.getName());
    String tableSchema;
    String tableCatalog;
    TreeMap<String, Table> tables = new TreeMap();

    public Schema(String tableSchema, String tableCatalog) {
        this.tableSchema = tableSchema != null ? tableSchema : "";
        this.tableCatalog = tableCatalog != null ? tableCatalog : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Schema> getSchemas(DatabaseMetaData metaData) throws SQLException {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        ResultSet rs = null;
        try {
            rs = metaData.getSchemas();
            while (rs.next()) {
                String tableSchema = rs.getString("TABLE_SCHEM");
                String tableCatalog = rs.getString("TABLE_CATALOG");
                Schema schema = new Schema(tableSchema, tableCatalog);
                schemas.add(schema);
            }
            if (schemas.isEmpty()) {
                schemas.add(new Schema("", "."));
            }
        }
        finally {
            try {
                if (rs != null && !rs.isClosed()) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
        }
        return schemas;
    }

    public Table put(Table table) {
        return this.tables.put(table.tableName.toUpperCase(), table);
    }

    public Table get(String tableName) {
        return this.tables.get(tableName.toUpperCase());
    }

    @Override
    public int compareTo(Schema o) {
        int compareTo = this.tableCatalog.compareToIgnoreCase(o.tableCatalog);
        if (compareTo == 0) {
            compareTo = this.tableSchema.compareToIgnoreCase(o.tableSchema);
        }
        return compareTo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Schema)) {
            return false;
        }
        Schema schema = (Schema)o;
        if (!this.tableSchema.equals(schema.tableSchema)) {
            return false;
        }
        if (!Objects.equals(this.tableCatalog, schema.tableCatalog)) {
            return false;
        }
        return Objects.equals(this.tables, schema.tables);
    }

    public int hashCode() {
        int result = this.tableSchema.hashCode();
        result = 31 * result + (this.tableCatalog != null ? this.tableCatalog.hashCode() : 0);
        result = 31 * result + (this.tables != null ? this.tables.hashCode() : 0);
        return result;
    }
}

