/*
 * Decompiled with CFR 0.152.
 */
package com.manticore.h2;

import com.manticore.h2.Column;
import com.manticore.h2.Index;
import com.manticore.h2.PrimaryKey;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;

public class Table
implements Comparable<Table> {
    public static final Logger LOGGER = Logger.getLogger(Table.class.getName());
    String tableCatalog;
    String tableSchema;
    String tableName;
    String tableType;
    String remarks;
    String typeCatalog;
    String typeSchema;
    String typeName;
    String selfReferenceColName;
    String referenceGeneration;
    TreeSet<Column> columns = new TreeSet();
    TreeMap<String, Index> indices = new TreeMap();
    PrimaryKey primaryKey = null;

    public Table(String tableCatalog, String tableSchema, String tableName, String tableType, String remarks, String typeCatalog, String typeSchema, String typeName, String selfReferenceColName, String referenceGeneration) {
        this.tableCatalog = tableCatalog;
        this.tableSchema = tableSchema;
        this.tableName = tableName;
        this.tableType = tableType;
        this.remarks = remarks;
        this.typeCatalog = typeCatalog;
        this.typeSchema = typeSchema;
        this.typeName = typeName;
        this.selfReferenceColName = selfReferenceColName;
        this.referenceGeneration = referenceGeneration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Table> getTables(DatabaseMetaData metaData) throws SQLException {
        ArrayList<Table> tables = new ArrayList<Table>();
        ArrayList<String> tableTypes = new ArrayList<String>();
        ResultSet rs = null;
        try {
            rs = metaData.getTableTypes();
            while (rs.next()) {
                tableTypes.add(rs.getString(1));
            }
            rs.close();
            rs = metaData.getTables(null, null, "%", tableTypes.toArray(new String[tableTypes.size()]));
            while (rs.next()) {
                String tableCatalog = rs.getString("TABLE_CAT");
                String tableSchema = rs.getString("TABLE_SCHEM");
                String tableName = rs.getString("TABLE_NAME");
                String tableType = rs.getString("TABLE_TYPE");
                String remarks = rs.getString("REMARKS");
                String typeCatalog = rs.getString("TYPE_CAT");
                String typeSchema = rs.getString("TYPE_SCHEM");
                String typeName = rs.getString("TYPE_NAME");
                String selfReferenceColName = rs.getString("SELF_REFERENCING_COL_NAME");
                String referenceGeneration = rs.getString("REF_GENERATION");
                Table table = new Table(tableCatalog, tableSchema, tableName, tableType, remarks, typeCatalog, typeSchema, typeName, selfReferenceColName, referenceGeneration);
                tables.add(table);
            }
        }
        finally {
            try {
                if (rs != null && !rs.isClosed()) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getColumns(DatabaseMetaData metaData) throws SQLException {
        ResultSet rs = null;
        try {
            rs = metaData.getColumns(this.tableCatalog, this.tableSchema, this.tableName, "%");
            while (rs.next()) {
                String tableCatalog = rs.getString("TABLE_CAT");
                String tableSchema = rs.getString("TABLE_SCHEM");
                String tableName = rs.getString("TABLE_NAME");
                String columnName = rs.getString("COLUMN_NAME");
                Integer dataType = rs.getInt("DATA_TYPE");
                String typeName = rs.getString("TYPE_NAME");
                Integer columnSize = rs.getInt("COLUMN_SIZE");
                Integer decimalDigits = rs.getInt("DECIMAL_DIGITS");
                Integer numericPrecicionRadix = rs.getInt("NUM_PREC_RADIX");
                Integer nullable = rs.getInt("NULLABLE");
                String remarks = rs.getString("REMARKS");
                String columnDefinition = rs.getString("COLUMN_DEF");
                Integer characterOctetLength = rs.getInt("CHAR_OCTET_LENGTH");
                Integer ordinalPosition = rs.getInt("ORDINAL_POSITION");
                String isNullable = rs.getString("IS_NULLABLE");
                String scopeCatalog = rs.getString("SCOPE_CATALOG");
                String scopeSchema = rs.getString("SCOPE_SCHEMA");
                String scopeTable = rs.getString("SCOPE_TABLE");
                Short sourceDataType = rs.getShort("SOURCE_DATA_TYPE");
                String isAutoIncrement = rs.getString("IS_AUTOINCREMENT");
                String isGeneratedColumn = rs.getString("IS_GENERATEDCOLUMN");
                Column column = new Column(tableCatalog, tableSchema, tableName, columnName, dataType, typeName, columnSize, decimalDigits, numericPrecicionRadix, nullable, remarks, columnDefinition, characterOctetLength, ordinalPosition, isNullable, scopeCatalog, scopeSchema, scopeTable, sourceDataType, isAutoIncrement, isGeneratedColumn);
                this.columns.add(column);
            }
        }
        finally {
            try {
                if (rs != null && !rs.isClosed()) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getIndices(DatabaseMetaData metaData, boolean approximate) throws SQLException {
        ResultSet rs = null;
        try {
            LOGGER.info(this.tableCatalog + "." + this.tableSchema + "." + this.tableName);
            rs = metaData.getIndexInfo(this.tableCatalog, this.tableSchema, this.tableName, false, approximate);
            while (rs.next()) {
                String tableCatalog = rs.getString("TABLE_CAT");
                String tableSchema = rs.getString("TABLE_SCHEM");
                String tableName = rs.getString("TABLE_NAME");
                Boolean nonUnique = rs.getBoolean("NON_UNIQUE");
                String indexQualifier = rs.getString("INDEX_QUALIFIER");
                String indexName = rs.getString("INDEX_NAME");
                Short type = rs.getShort("TYPE");
                Short ordinalPosition = rs.getShort("ORDINAL_POSITION");
                String columnName = rs.getString("COLUMN_NAME");
                String ascOrDesc = rs.getString("ASC_OR_DESC");
                Long cardinality = rs.getLong("CARDINALITY");
                Long pages = rs.getLong("PAGES");
                String filterCondition = rs.getString("FILTER_CONDITION");
                Index index = this.indices.get(indexName.toUpperCase());
                if (index == null) {
                    index = new Index(tableCatalog, tableSchema, tableName, nonUnique, indexQualifier, indexName, type);
                    this.indices.put(index.indexName, index);
                }
                index.put(ordinalPosition, columnName, ascOrDesc, cardinality, pages, filterCondition);
            }
        }
        finally {
            try {
                if (rs != null && !rs.isClosed()) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPrimaryKey(DatabaseMetaData metaData) throws SQLException {
        ResultSet rs = null;
        try {
            rs = metaData.getPrimaryKeys(this.tableCatalog, this.tableSchema, this.tableName);
            TreeMap<Short, String> columnNames = new TreeMap<Short, String>();
            while (rs.next()) {
                String tableCatalog = rs.getString("TABLE_CAT");
                String tableSchema = rs.getString("TABLE_SCHEM");
                String tableName = rs.getString("TABLE_NAME");
                String columnName = rs.getString("COLUMN_NAME");
                Short keySequence = rs.getShort("KEY_SEQ");
                String primaryKeyName = rs.getString("PK_NAME");
                if (this.primaryKey == null) {
                    this.primaryKey = new PrimaryKey(tableCatalog, tableSchema, tableName, primaryKeyName);
                }
                columnNames.put(keySequence, columnName);
            }
            for (Map.Entry e : columnNames.entrySet()) {
                this.primaryKey.columnNames.add((String)e.getValue());
            }
        }
        finally {
            try {
                if (rs != null && !rs.isClosed()) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public int compareTo(Table o) {
        int compareTo = this.tableCatalog.compareToIgnoreCase(o.tableCatalog);
        if (compareTo == 0) {
            compareTo = this.tableSchema.compareToIgnoreCase(o.tableSchema);
        }
        if (compareTo == 0) {
            compareTo = this.tableName.compareToIgnoreCase(o.tableName);
        }
        return compareTo;
    }

    public boolean add(Column column) {
        return this.columns.add(column);
    }

    public boolean contains(Column column) {
        return this.columns.contains(column);
    }

    public Index put(Index index) {
        return this.indices.put(index.indexName.toUpperCase(), index);
    }

    public boolean containsIndexKey(String indexName) {
        return this.indices.containsKey(indexName.toUpperCase());
    }

    public Index get(String indexName) {
        return this.indices.get(indexName.toUpperCase());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Table)) {
            return false;
        }
        Table table = (Table)o;
        if (!Objects.equals(this.tableCatalog, table.tableCatalog)) {
            return false;
        }
        if (!Objects.equals(this.tableSchema, table.tableSchema)) {
            return false;
        }
        if (!this.tableName.equals(table.tableName)) {
            return false;
        }
        if (!this.tableType.equals(table.tableType)) {
            return false;
        }
        if (!Objects.equals(this.remarks, table.remarks)) {
            return false;
        }
        if (!Objects.equals(this.typeCatalog, table.typeCatalog)) {
            return false;
        }
        if (!Objects.equals(this.typeSchema, table.typeSchema)) {
            return false;
        }
        if (!Objects.equals(this.typeName, table.typeName)) {
            return false;
        }
        if (!Objects.equals(this.selfReferenceColName, table.selfReferenceColName)) {
            return false;
        }
        if (!Objects.equals(this.referenceGeneration, table.referenceGeneration)) {
            return false;
        }
        if (!this.columns.equals(table.columns)) {
            return false;
        }
        if (!Objects.equals(this.indices, table.indices)) {
            return false;
        }
        return Objects.equals(this.primaryKey, table.primaryKey);
    }

    public int hashCode() {
        int result = this.tableCatalog != null ? this.tableCatalog.hashCode() : 0;
        result = 31 * result + (this.tableSchema != null ? this.tableSchema.hashCode() : 0);
        result = 31 * result + this.tableName.hashCode();
        result = 31 * result + this.tableType.hashCode();
        result = 31 * result + (this.remarks != null ? this.remarks.hashCode() : 0);
        result = 31 * result + (this.typeCatalog != null ? this.typeCatalog.hashCode() : 0);
        result = 31 * result + (this.typeSchema != null ? this.typeSchema.hashCode() : 0);
        result = 31 * result + (this.typeName != null ? this.typeName.hashCode() : 0);
        result = 31 * result + (this.selfReferenceColName != null ? this.selfReferenceColName.hashCode() : 0);
        result = 31 * result + (this.referenceGeneration != null ? this.referenceGeneration.hashCode() : 0);
        result = 31 * result + this.columns.hashCode();
        result = 31 * result + (this.indices != null ? this.indices.hashCode() : 0);
        result = 31 * result + (this.primaryKey != null ? this.primaryKey.hashCode() : 0);
        return result;
    }
}

